/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skyWars.game;

import java.util.HashMap;
import java.util.List;
import me.tomqnto.skyWars.Message;
import me.tomqnto.skyWars.game.Game;
import me.tomqnto.skyWars.game.GameManager;
import me.tomqnto.skyWars.game.GameSettings;
import me.tomqnto.skyWars.game.GameState;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class GameJoinHandler {
    private static final List<GameState> requiredStates = List.of(GameState.STARTING, GameState.WAITING);

    public static void joinGame(Player player, GameSettings gameSettings, GameManager gameManager) {
        if (gameManager.hasActiveSession(player)) {
            return;
        }
        HashMap<String, Game> games = gameManager.getGames();
        if (!games.isEmpty()) {
            for (Game game : games.values()) {
                if (gameSettings != game.getGameSettings() || game.getPlayerCount() >= game.getMaxPlayers() || !requiredStates.contains((Object)game.getGameState())) continue;
                GameJoinHandler.sendJoinMessage(player, game.getId());
                game.playerJoin(player);
                return;
            }
        } else {
            Game game = gameManager.createGame(gameSettings);
            GameJoinHandler.sendJoinMessage(player, game.getId());
            game.playerJoin(player);
            return;
        }
        Message.send((CommandSender)player, "<red>Could not find a game to join");
    }

    public static void joinGame(Player player, String id, GameManager gameManager) {
        Game game = gameManager.getGames().get(id);
        if (game == null) {
            Message.send((CommandSender)player, "<red>This game does not exist");
            return;
        }
        if (game.getGameState() == GameState.STARTING || game.getGameState() == GameState.WAITING) {
            GameJoinHandler.sendJoinMessage(player, id);
            game.playerJoin(player);
        }
    }

    public static void sendJoinMessage(Player player, String id) {
        Message.send((CommandSender)player, "<gray>Joined %s".formatted(id));
    }
}

