/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skyWars.game;

import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import me.tomqnto.skyWars.SkyWars;
import me.tomqnto.skyWars.configs.MapConfig;
import me.tomqnto.skyWars.game.Game;
import me.tomqnto.skyWars.game.GameMap;
import me.tomqnto.skyWars.game.GameSettings;
import me.tomqnto.skyWars.game.PlayerSession;
import me.tomqnto.skyWars.menus.GamesMenu;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class GameManager {
    private final HashMap<String, Game> games = new HashMap();
    private final HashMap<Player, PlayerSession> playerSessions = new HashMap();
    private final GamesMenu gamesMenu = new GamesMenu(this);

    @Nullable
    public Game createGame(GameSettings gameSettings) {
        List<String> maps = MapConfig.getMaps();
        if (maps.isEmpty()) {
            return null;
        }
        GameMap map = new GameMap(maps.get(new Random().nextInt(maps.size())));
        Game game = new Game(gameSettings, this, map);
        this.games.put(game.getId().toString(), game);
        return game;
    }

    @Nullable
    public PlayerSession getPlayerSession(Player player) {
        return this.playerSessions.get(player);
    }

    @Nullable
    public PlayerSession createPlayerSession(Player player, Game game) {
        if (this.getPlayerSession(player) != null) {
            return null;
        }
        return this.playerSessions.put(player, new PlayerSession(game));
    }

    public void deletePlayerSession(Player player) {
        if (this.getPlayerSession(player) != null) {
            this.playerSessions.remove(player);
        }
    }

    public boolean hasActiveSession(Player player) {
        return this.getPlayerSession(player) != null;
    }

    public HashMap<String, Game> getGames() {
        return this.games;
    }

    public HashMap<Player, PlayerSession> getPlayerSessions() {
        return this.playerSessions;
    }

    public GamesMenu getGamesMenu() {
        return this.gamesMenu;
    }

    public Location getLobbyLocation() {
        return SkyWars.getInstance().getConfig().getLocation("lobby-location");
    }

    public static String GameIdGenerator() {
        String id = "sw-%s-%s-%s";
        String uuid = UUID.randomUUID().toString().substring(0, 8);
        String time = String.valueOf(System.currentTimeMillis());
        String time2 = time.substring(0, 4);
        time = time.substring(time.length() - 5);
        return id.formatted(time, uuid, time2);
    }
}

