/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skyWars.game;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import me.tomqnto.skyWars.SkyWars;
import me.tomqnto.skyWars.configs.MapConfig;
import net.kyori.adventure.util.TriState;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.codehaus.plexus.util.FileUtils;

public class GameMap {
    private final File sourceWorldFolder;
    private final String worldName;
    private File activeWorldFolder;
    private World bukkitWorld;

    public GameMap(String worldName) {
        this.worldName = worldName;
        this.sourceWorldFolder = new File(new File(SkyWars.getInstance().getDataFolder(), "maps"), worldName);
        this.load();
    }

    public boolean load() {
        if (this.isLoaded()) {
            return true;
        }
        System.out.println(this.activeWorldFolder);
        this.activeWorldFolder = new File(Bukkit.getWorldContainer(), this.sourceWorldFolder.getName() + "_active_" + System.currentTimeMillis());
        try {
            FileUtils.copyDirectoryStructure((File)this.sourceWorldFolder, (File)this.activeWorldFolder);
            SkyWars.getInstance().getLoadedMaps().add(this);
            this.bukkitWorld = Bukkit.createWorld((WorldCreator)new WorldCreator(this.activeWorldFolder.getName()).keepSpawnLoaded(TriState.FALSE));
            if (this.bukkitWorld != null) {
                this.bukkitWorld.setAutoSave(false);
                this.bukkitWorld.setPVP(false);
                this.bukkitWorld.setGameRule(GameRule.DO_MOB_SPAWNING, (Object)false);
            }
        }
        catch (Exception e) {
            Bukkit.getLogger().severe("Could not load world: " + this.activeWorldFolder.getName());
            e.printStackTrace();
            return false;
        }
        return this.isLoaded();
    }

    public void unload() {
        if (this.bukkitWorld != null) {
            Bukkit.unloadWorld((World)this.bukkitWorld, (boolean)false);
        }
        if (this.activeWorldFolder != null) {
            try {
                FileUtils.deleteDirectory((File)this.activeWorldFolder);
                SkyWars.getInstance().getLoadedMaps().remove(this);
                Bukkit.getLogger().info("Deleted active world: " + this.activeWorldFolder.getName());
            }
            catch (IOException e) {
                Bukkit.getLogger().severe("Could not delete active world: " + this.activeWorldFolder.getName());
                e.printStackTrace();
            }
        }
        this.bukkitWorld = null;
        this.activeWorldFolder = null;
    }

    private boolean isLoaded() {
        return this.bukkitWorld != null;
    }

    public World getBukkitWorld() {
        return this.bukkitWorld;
    }

    public String getName() {
        return this.worldName;
    }

    public List<Location> getTeamSpawnLocations() {
        ArrayList<Location> locations = new ArrayList<Location>();
        for (List<Double> coordsList : MapConfig.getTeamSpawnCoordinates(this.getName())) {
            locations.add(new Location(this.bukkitWorld, coordsList.getFirst().doubleValue(), coordsList.get(1).doubleValue(), coordsList.getLast().doubleValue()));
        }
        return locations;
    }

    public Location getWaitingArea() {
        List<Double> coords = MapConfig.getWaitingAreaCoordinates(this.getName());
        return new Location(this.bukkitWorld, coords.getFirst().doubleValue(), coords.get(1).doubleValue(), coords.getLast().doubleValue());
    }

    public List<Location> getChestLocations() {
        List<List<Integer>> intList = MapConfig.getChestCoordinates(this.getName());
        ArrayList<Location> locationList = new ArrayList<Location>();
        for (List<Integer> intLocations : intList) {
            int x = intLocations.getFirst();
            int y = intLocations.get(1);
            int z = intLocations.getLast();
            locationList.add(new Location(this.getBukkitWorld(), (double)x, (double)y, (double)z));
        }
        return locationList;
    }
}

