/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skyWars.game;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.jetbrains.annotations.NotNull;

public class GameSettings
implements ConfigurationSerializable {
    private final String name;
    private final int minTeams;
    private final int maxTeams;
    private final int teamSize;
    private final String[] allowedMapTags;
    private final int chestRefillCooldown;
    public static GameSettings SOLOS_SETTINGS = new GameSettings("Solos", 4, 12, 1, 120, "solos");
    public static GameSettings DUOS_SETTINGS = new GameSettings("Duos", 4, 12, 2, 20, "duos");

    public GameSettings(String name, int minTeams, int maxTeams, int teamSize, int chestRefillCooldown, String ... allowedMapTags) {
        this.maxTeams = maxTeams;
        this.minTeams = minTeams;
        this.name = name;
        this.teamSize = teamSize;
        this.chestRefillCooldown = chestRefillCooldown;
        this.allowedMapTags = allowedMapTags;
    }

    public int getMaxTeams() {
        return this.maxTeams;
    }

    public int getMinTeams() {
        return this.minTeams;
    }

    public String getName() {
        return this.name;
    }

    public String[] getAllowedMapTags() {
        return this.allowedMapTags;
    }

    @NotNull
    public Map<String, Object> serialize() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", this.name);
        map.put("min-teams", this.minTeams);
        map.put("max-teams", this.maxTeams);
        map.put("team-size", this.teamSize);
        map.put("chest-refill-cooldown", this.chestRefillCooldown);
        map.put("allowed-map-tags", this.allowedMapTags);
        return map;
    }

    public static GameSettings deserialize(Map<String, Object> map) {
        String name = (String)map.get("name");
        int minPlayers = (Integer)map.get("min-teams");
        int maxPlayers = (Integer)map.get("max-teams");
        int teamSize = (Integer)map.get("team-size");
        int chestRefillCooldown = (Integer)map.get("chest-refill-cooldown");
        List tags = (List)map.get("allowed-map-tags");
        String[] allowedMapTags = tags.toArray(new String[0]);
        return new GameSettings(name, maxPlayers, minPlayers, teamSize, chestRefillCooldown, allowedMapTags);
    }

    public int getTeamSize() {
        return this.teamSize;
    }

    public int getChestRefillCooldown() {
        return this.chestRefillCooldown;
    }
}

