/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skyWars.game;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class LootItem {
    private final ItemStack itemStack;
    private final String customName;
    private final double chance;
    private final int minAmount;
    private final int maxAmount;

    public LootItem(ConfigurationSection section) {
        this.itemStack = section.getItemStack("item-stack");
        this.customName = section.getString("name");
        this.chance = section.getDouble("chance");
        this.minAmount = section.getInt("min-amount");
        this.maxAmount = section.getInt("max-amount");
    }

    public boolean shouldFill(Random random) {
        return random.nextDouble() < this.chance;
    }

    public ItemStack make(ThreadLocalRandom random) {
        int amount = random.nextInt(this.minAmount, this.maxAmount + 1);
        ItemStack itemStack = this.itemStack;
        itemStack.setAmount(amount);
        if (itemStack.hasItemMeta()) {
            ItemMeta itemMeta = itemStack.getItemMeta();
            if (this.customName != null) {
                itemMeta.itemName((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(this.customName));
            }
            itemStack.setItemMeta(itemMeta);
        }
        return itemStack;
    }
}

