/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skyWars.listeners;

import io.papermc.paper.event.player.AsyncChatEvent;
import me.tomqnto.skyWars.Message;
import me.tomqnto.skyWars.game.Game;
import me.tomqnto.skyWars.game.GameManager;
import me.tomqnto.skyWars.game.GameState;
import me.tomqnto.skyWars.game.PlayerSession;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.CommandSender;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.util.Vector;

public class InGameListeners
implements Listener {
    private final GameManager gameManager;

    public InGameListeners(GameManager gameManager) {
        this.gameManager = gameManager;
    }

    @EventHandler
    public void onTeleport(PlayerTeleportEvent event) {
        if (this.gameManager.hasActiveSession(event.getPlayer()) && event.getTo().getWorld() != this.gameManager.getPlayerSession(event.getPlayer()).getGame().getMap().getBukkitWorld()) {
            event.setCancelled(true);
            Message.send((CommandSender)event.getPlayer(), "<red>Teleport canceled: Cannot teleport out of the game world");
        }
    }

    @EventHandler
    public void onProjectileHitPlayer(ProjectileHitEvent event) {
        Player player;
        Entity entity;
        if (event.getHitEntity() != null && (entity = event.getHitEntity()) instanceof Player && this.gameManager.hasActiveSession(player = (Player)entity) && (event.getEntity().getType() == EntityType.SNOWBALL || event.getEntityType() == EntityType.EGG)) {
            player.damage(1.0E-4);
            Vector velocity = event.getEntity().getVelocity();
            velocity = velocity.multiply(0.3);
            player.knockback(0.4, -velocity.getX(), -velocity.getZ());
        }
    }

    @EventHandler
    public void onPlayerDie(PlayerDeathEvent event) {
        Player player = event.getPlayer();
        if (this.gameManager.hasActiveSession(player)) {
            Game game = this.gameManager.getPlayerSession(player).getGame();
            if (game.getGameState() == GameState.STARTED) {
                game.playerDie(player);
                game.broadcastMessage(event.deathMessage().color((TextColor)NamedTextColor.RED));
                event.deathMessage((Component)Component.empty());
            } else {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        if (this.gameManager.hasActiveSession(player) && this.gameManager.getPlayerSession(player).getGame().getGameState() != GameState.STARTED) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        if (this.gameManager.hasActiveSession(player) && this.gameManager.getPlayerSession(player).getGame().getGameState() != GameState.STARTED) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (!this.gameManager.hasActiveSession(player)) {
            return;
        }
        Game game = this.gameManager.getPlayerSession(player).getGame();
        if (game.getGameState() != GameState.STARTED) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerHurt(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!this.gameManager.hasActiveSession(player)) {
            return;
        }
        Game game = this.gameManager.getPlayerSession(player).getGame();
        if (game.getGameState() != GameState.STARTED) {
            event.setCancelled(true);
        }
        if (event.getDamageSource().getDamageType() == DamageType.OUT_OF_WORLD) {
            if (game.getGameState() != GameState.STARTED) {
                if (game.getGameState() == GameState.WAITING) {
                    player.teleport(game.getMap().getWaitingArea());
                } else {
                    player.teleport(game.getTeamSpawnLocations().get(game.getTeam(player)));
                }
            } else {
                player.setHealth(0.0);
            }
        }
    }

    @EventHandler
    public void onChatEvent(AsyncChatEvent event) {
        Player player = event.getPlayer();
        PlayerSession playerSession = this.gameManager.getPlayerSession(player);
        if (playerSession != null) {
            event.viewers().clear();
            event.viewers().addAll(playerSession.getGame().getGamePlayers().keySet());
            event.renderer((sender, name, message, audience) -> ((TextComponent)Component.text((String)sender.getName(), (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)": "))).append(message.color((TextColor)NamedTextColor.WHITE)));
        } else {
            for (Player p : this.gameManager.getPlayerSessions().keySet()) {
                event.viewers().remove(p);
            }
        }
    }
}

