/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skyWars.menus;

import java.util.ArrayList;
import java.util.List;
import me.tomqnto.skyWars.game.Game;
import me.tomqnto.skyWars.game.GameManager;
import me.tomqnto.skyWars.game.GameState;
import me.tomqnto.skyWars.menus.api.Button;
import me.tomqnto.skyWars.menus.api.PagedMenu;
import me.tomqnto.skyWars.menus.api.SimpleMenu;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class GamesMenu
extends PagedMenu {
    private final GameManager gameManager;

    public GamesMenu(GameManager gameManager) {
        super(SimpleMenu.Rows.FIVE, (Component)Component.text((String)"Games"));
        this.gameManager = gameManager;
    }

    @Override
    public void onSetup() {
        List<Game> games = this.gameManager.getGames().values().stream().filter(game -> List.of(GameState.WAITING, GameState.STARTING).contains((Object)game.getGameState())).toList();
        ArrayList<Button> buttons = new ArrayList<Button>();
        for (Game game2 : games) {
            ItemStack item = new ItemStack(Material.ENDER_EYE);
            ItemMeta meta = item.getItemMeta();
            meta.itemName((Component)Component.text((String)"Skywars", (TextColor)NamedTextColor.GOLD));
            String playerCount = "%s/%s".formatted(game2.getPlayerCount(), game2.getMaxPlayers());
            String map = game2.getMap().getName();
            String id = game2.getId();
            TextComponent empty = Component.empty();
            Component lore1 = Component.text((String)id, (TextColor)NamedTextColor.DARK_GRAY).decoration(TextDecoration.ITALIC, false);
            Component lore2 = Component.text((String)"Players: %s".formatted(playerCount), (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, false);
            Component lore3 = Component.text((String)"Map: %s".formatted(map), (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, false);
            meta.lore(List.of(lore1, empty, lore2, lore3, empty));
            item.setItemMeta(meta);
            buttons.add(new Button(item, player -> player.performCommand("sw join id:%s".formatted(id))));
        }
        this.addAll(buttons);
    }
}

