/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skyWars.menus.api;

import java.util.HashMap;
import java.util.function.Consumer;
import me.tomqnto.skyWars.SkyWars;
import me.tomqnto.skyWars.menus.api.Menu;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public abstract class SimpleMenu
implements Menu,
Listener {
    private final Inventory inventory;
    private HashMap<Integer, Consumer<Player>> actionsMap = new HashMap();
    private HashMap<Integer, ItemStack> itemsMap = new HashMap();

    public SimpleMenu(Rows rows, Component title) {
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)rows.getSize(), (Component)title);
        SkyWars.getInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)SkyWars.getInstance());
    }

    @Override
    public void click(Player player, int slot) {
        Consumer<Player> action = this.actionsMap.get(slot);
        if (action != null) {
            action.accept(player);
        }
    }

    @Override
    public void setItem(int slot, ItemStack item) {
        this.setItem(slot, item, player -> {});
    }

    @Override
    public void setItem(int slot, ItemStack item, Consumer<Player> action) {
        this.actionsMap.put(slot, action);
        this.itemsMap.put(slot, item);
        this.getInventory().setItem(slot, item);
    }

    @Override
    public void update() {
        this.inventory.clear();
        this.itemsMap.clear();
        this.actionsMap.clear();
        this.onSetup();
    }

    @Override
    public abstract void onSetup();

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    public HashMap<Integer, ItemStack> getItemsMap() {
        return this.itemsMap;
    }

    public HashMap<Integer, Consumer<Player>> getActionsMap() {
        return this.actionsMap;
    }

    public static enum Rows {
        ONE(1),
        TWO(2),
        THREE(3),
        FOUR(4),
        FIVE(5),
        SIX(6);

        private final int size;

        private Rows(int rows) {
            this.size = rows * 9;
        }

        public int getSize() {
            return this.size;
        }
    }
}

