/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skyWars.tasks;

import java.time.Duration;
import me.tomqnto.skyWars.game.Game;
import me.tomqnto.skyWars.game.GameState;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

public class StartCountdown
extends BukkitRunnable {
    private final Game game;
    private int time = 60;

    public StartCountdown(Game game) {
        this.game = game;
    }

    public void run() {
        if (this.game.getGameState() == GameState.WAITING) {
            for (Player player : this.game.getGamePlayers().keySet()) {
                player.sendActionBar((Component)Component.text((String)"Not enough players to start", (TextColor)NamedTextColor.GRAY));
            }
        }
        if (this.game.getGameState() == GameState.STARTING) {
            for (Player player : this.game.getGamePlayers().keySet()) {
                player.sendActionBar(MiniMessage.miniMessage().deserialize((Object)"<gold>Starting in <gold>%ss".formatted(this.time)));
            }
            if (this.time == 30 || this.time == 20 || this.time == 15 || this.time < 11 && this.time > 0) {
                this.game.broadcastMessage("<yellow>Starting in <gold>%s <yellow>seconds".formatted(this.time));
                this.game.getGamePlayers().keySet().forEach(Audience::clearTitle);
                this.game.broadcastTitle((Component)Component.text((String)"Starting in", (TextColor)NamedTextColor.YELLOW, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}), Component.text((int)this.time, (TextColor)NamedTextColor.GOLD, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}).append((Component)Component.text((String)" seconds", (TextColor)NamedTextColor.YELLOW, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD})), Duration.ofMillis(100L), Duration.ofMillis(1000L), Duration.ofMillis(100L), null);
            }
            if (this.time <= 0) {
                this.game.getGamePlayers().keySet().forEach(Audience::clearTitle);
                this.game.broadcastTitle(((TextComponent)Component.text((String)"Game started!").color((TextColor)NamedTextColor.GOLD)).decorate(TextDecoration.BOLD), (Component)Component.space(), null);
                this.game.setGameState(GameState.STARTED);
                this.cancel();
                return;
            }
            --this.time;
        }
    }

    public void setTime(int time) {
        this.time = time;
    }
}

