/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skywars.command.arguments;

import me.tomqnto.skywars.Message;
import me.tomqnto.skywars.command.ArgumentExecutor;
import me.tomqnto.skywars.configs.GameConfigurationManager;
import me.tomqnto.skywars.game.GameConfiguration;
import me.tomqnto.skywars.game.GameJoinHandler;
import me.tomqnto.skywars.game.GameManager;
import me.tomqnto.skywars.menus.JoinMenu;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class JoinGameArgument
implements ArgumentExecutor {
    private final GameManager gameManager;

    public JoinGameArgument(GameManager gameManager) {
        this.gameManager = gameManager;
    }

    public void execute(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            Message.PLAYER_ONLY_COMMAND.send(sender);
            return;
        }
        Player player = (Player)sender;
        if (this.gameManager.hasActiveSession(player)) {
            Message.COMMAND_NOT_ALLOWED_IN_GAME.send((CommandSender)player);
            return;
        }
        if (args.length == 1) {
            new JoinMenu().open(player);
            return;
        }
        if (args.length == 2) {
            if (args[1].startsWith("id:")) {
                GameJoinHandler.joinGame((Player)player, (String)args[1].substring(4), (GameManager)this.gameManager);
            } else if (GameConfigurationManager.doesExist((String)args[1])) {
                GameJoinHandler.joinGame((Player)player, (GameConfiguration)GameConfigurationManager.getGameConfiguration((String)args[1]), (GameManager)this.gameManager);
            } else {
                Message.send((CommandSender)player, (String)"<red>Invalid config or id");
            }
        }
    }

    public String getUsage() {
        return "/skywarsplus join <id:gameid | config | empty>";
    }

    public String getDescription() {
        return "Used to join a game";
    }
}

