/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skywars.game;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import me.tomqnto.skywars.SkywarsPlus;
import me.tomqnto.skywars.game.Game;
import me.tomqnto.skywars.game.GameManager;
import me.tomqnto.skywars.game.GameState;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class GameScoreboard
extends BukkitRunnable {
    private final Game game;
    private final GameManager gameManager;
    private final HashMap<Player, Boolean> hasRegisteredStartedTeams;
    private final HashMap<Player, Boolean> hasScoreboard;

    public GameScoreboard(Game game, GameManager gameManager) {
        this.game = game;
        this.gameManager = gameManager;
        this.hasRegisteredStartedTeams = new HashMap();
        this.hasScoreboard = new HashMap();
    }

    public void run() {
        for (Player player : this.game.getInGamePlayers()) {
            boolean hasSb = this.hasScoreboard.getOrDefault(player, false);
            if ((!this.gameManager.hasActiveSession(player) || this.gameManager.getPlayerSession(player).getGame() != this.game || this.game.getGameState() == GameState.ENDED) && hasSb) {
                this.removeScoreboard(player);
                this.hasScoreboard.put(player, false);
                this.hasRegisteredStartedTeams.put(player, false);
                continue;
            }
            if (player.getScoreboard().getObjective(SkywarsPlus.getInstance().getName()) != null) {
                this.updateScoreboard(player);
                continue;
            }
            if (hasSb || this.game.getGameState() == GameState.ENDED) continue;
            this.createScoreboard(player);
            this.hasScoreboard.put(player, true);
        }
    }

    public void createScoreboard(Player player) {
        this.hasScoreboard.put(player, true);
        this.hasRegisteredStartedTeams.put(player, false);
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getNewScoreboard();
        Objective objective = scoreboard.registerNewObjective(SkywarsPlus.getInstance().getName(), "dummy");
        objective.setDisplaySlot(DisplaySlot.SIDEBAR);
        objective.displayName((Component)Component.text((String)"SkyWars+", (TextColor)NamedTextColor.GOLD, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}));
        Team countdown = scoreboard.registerNewTeam("countdown");
        countdown.addEntry(ChatColor.DARK_BLUE.toString());
        countdown.prefix((Component)Component.text((String)"Starting in: ", (TextColor)NamedTextColor.GREEN));
        countdown.suffix((Component)Component.text((String)(this.game.getStartCountdown().getTime() + "s"), (TextColor)NamedTextColor.GREEN));
        objective.getScore(ChatColor.DARK_BLUE.toString()).setScore(8);
        Team playerCount = scoreboard.registerNewTeam("playerCount");
        playerCount.addEntry(ChatColor.DARK_AQUA.toString());
        playerCount.prefix((Component)Component.text((String)"Players: "));
        playerCount.suffix((Component)Component.text((String)(this.game.getAlivePlayers().size() + "/" + this.game.getMaxPlayers())));
        objective.getScore(ChatColor.DARK_AQUA.toString()).setScore(5);
        Team config = scoreboard.registerNewTeam("Config");
        config.addEntry(ChatColor.YELLOW.toString());
        config.prefix((Component)Component.text((String)"Config: "));
        config.suffix((Component)Component.text((String)this.game.getGameConfiguration().getName()));
        objective.getScore(ChatColor.YELLOW.toString()).setScore(0);
        Team map = scoreboard.registerNewTeam("Map");
        map.addEntry(ChatColor.RED.toString());
        map.prefix((Component)Component.text((String)"Map: "));
        map.suffix((Component)Component.text((String)this.game.getMap().getName()));
        objective.getScore(ChatColor.RED.toString()).setScore(1);
        LocalDateTime dateTime = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MM/dd/yyyy");
        objective.getScore("\u00a77" + formatter.format(dateTime)).setScore(10);
        objective.getScore(String.valueOf(ChatColor.DARK_GREEN) + " ").setScore(4);
        objective.getScore(String.valueOf(ChatColor.DARK_PURPLE) + " ").setScore(9);
        objective.getScore(String.valueOf(ChatColor.DARK_GRAY) + " ").setScore(7);
        player.setScoreboard(scoreboard);
    }

    public void updateScoreboard(Player player) {
        Scoreboard scoreboard = player.getScoreboard();
        if (!this.hasRegisteredStartedTeams.getOrDefault(player, false).booleanValue() && this.game.getGameState() == GameState.STARTED) {
            this.registerGameStartedTeams(scoreboard, scoreboard.getObjective(SkywarsPlus.getInstance().getName()), player);
            this.hasRegisteredStartedTeams.put(player, true);
        }
        if (this.game.getGameState() == GameState.STARTED) {
            Team chestRefill;
            Team teamsLeft;
            Team playersLeft;
            Team kills = scoreboard.getTeam("kills");
            if (kills != null) {
                kills.suffix((Component)Component.text((int)this.gameManager.getPlayerSession(player).getKills(), (TextColor)NamedTextColor.AQUA));
            }
            if ((playersLeft = scoreboard.getTeam("playersLeft")) != null) {
                playersLeft.suffix((Component)Component.text((int)this.game.getAlivePlayers().size()));
            }
            if (this.game.getGameConfiguration().getTeamSize() > 1 && (teamsLeft = scoreboard.getTeam("teamsLeft")) != null) {
                teamsLeft.suffix((Component)Component.text((int)this.game.getAliveTeams().size()));
            }
            if ((chestRefill = scoreboard.getTeam("chestRefill")) != null) {
                chestRefill.suffix((Component)Component.text((String)this.game.getChestRefillCountdown().getTimeLeftFormatted(), (TextColor)NamedTextColor.GREEN));
            }
        }
        if (this.game.getGameState() == GameState.WAITING || this.game.getGameState() == GameState.STARTING) {
            Team playerCount;
            Team countdown = scoreboard.getTeam("countdown");
            if (countdown != null) {
                if (this.game.getGameState() == GameState.WAITING) {
                    countdown.prefix((Component)Component.text((String)"Not enough players to start", (TextColor)NamedTextColor.GRAY));
                    countdown.suffix((Component)Component.empty());
                } else {
                    countdown.prefix((Component)Component.text((String)"Starting in: ", (TextColor)NamedTextColor.GREEN));
                    countdown.suffix((Component)Component.text((String)(this.game.getStartCountdown().getTime() + "s"), (TextColor)NamedTextColor.GREEN));
                }
            }
            if ((playerCount = scoreboard.getTeam("playerCount")) != null) {
                playerCount.suffix((Component)Component.text((String)(this.game.getAlivePlayers().size() + "/" + this.game.getMaxPlayers())));
            }
        }
    }

    public void removeScoreboard(Player player) {
        player.getScoreboard().getObjectives().forEach(Objective::unregister);
        player.getScoreboard().getTeams().forEach(Team::unregister);
        player.setScoreboard(Bukkit.getScoreboardManager().getMainScoreboard());
    }

    public void registerGameStartedTeams(Scoreboard scoreboard, Objective objective, Player player) {
        scoreboard.getTeam("countdown").unregister();
        scoreboard.getTeam("playerCount").unregister();
        objective.getScore(String.valueOf(ChatColor.GOLD) + " ").setScore(2);
        Team kills = scoreboard.registerNewTeam("kills");
        kills.addEntry(ChatColor.AQUA.toString());
        kills.prefix((Component)Component.text((String)"Kills: "));
        kills.suffix((Component)Component.text((int)this.gameManager.getPlayerSession(player).getKills(), (TextColor)NamedTextColor.AQUA));
        objective.getScore(ChatColor.AQUA.toString()).setScore(3);
        Team playersLeft = scoreboard.registerNewTeam("playersLeft");
        playersLeft.addEntry(ChatColor.DARK_AQUA.toString());
        playersLeft.prefix((Component)Component.text((String)"Players left: "));
        playersLeft.suffix((Component)Component.text((int)this.game.getAlivePlayers().size()));
        objective.getScore(ChatColor.DARK_AQUA.toString()).setScore(5);
        if (this.game.getGameConfiguration().getTeamSize() > 1) {
            Team teamsLeft = scoreboard.registerNewTeam("teamsLeft");
            teamsLeft.addEntry(ChatColor.BLUE.toString());
            teamsLeft.prefix((Component)Component.text((String)"Teams left: "));
            teamsLeft.suffix((Component)Component.text((int)this.game.getAliveTeams().size()));
            objective.getScore(ChatColor.BLUE.toString()).setScore(6);
        }
        Team chestRefill = scoreboard.registerNewTeam("chestRefill");
        chestRefill.addEntry(ChatColor.DARK_BLUE.toString());
        chestRefill.prefix((Component)Component.text((String)"Chest refill: "));
        chestRefill.suffix((Component)Component.text((String)this.game.getChestRefillCountdown().getTimeLeftFormatted(), (TextColor)NamedTextColor.GREEN));
        objective.getScore(ChatColor.DARK_BLUE.toString()).setScore(8);
    }
}

