/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skywars.menus.api;

import java.util.List;
import me.tomqnto.skywars.menus.api.Button;
import me.tomqnto.skywars.menus.api.SimpleMenu;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class PagedMenu
extends SimpleMenu {
    private int currentPage = 0;
    private int maxPage = 0;

    public PagedMenu(SimpleMenu.Rows rows, Component title) {
        super(rows, title);
        this.setNavigation();
    }

    protected void setNavigation() {
        if (this.maxPage == 0) {
            return;
        }
        this.setItem(this.getInventory().getSize() - 1, this.getItemNextPage(), player -> {
            this.currentPage = Math.min(this.maxPage, this.currentPage + 1);
            this.update();
        });
        this.setItem(this.getInventory().getSize() - 9, this.getItemPreviousPage(), player -> {
            this.currentPage = Math.max(0, this.currentPage - 1);
            this.update();
        });
    }

    public void addAll(List<Button> buttons) {
        int minus = 9;
        if (this.maxPage == 0) {
            minus = 0;
        }
        int safeArea = this.getInventory().getSize() - minus;
        for (int i = 0; i < buttons.size(); ++i) {
            int page = i / safeArea;
            int slot = i % safeArea;
            this.setButton(page, slot, buttons.get(i));
        }
    }

    public void update() {
        this.getItemsMap().clear();
        this.getActionsMap().clear();
        this.getInventory().clear();
        this.onSetup();
        this.setNavigation();
    }

    public void setButton(int page, int slot, Button button) {
        int index = page * this.getInventory().getSize() + slot;
        this.getActionsMap().put(index, button.getAction());
        this.getItemsMap().put(index, button.getItemStack());
        if (page == 0) {
            this.getInventory().setItem(index, button.getItemStack());
        }
        if (page > this.maxPage) {
            this.maxPage = page;
        }
    }

    public ItemStack getItemPreviousPage() {
        ItemStack item = new ItemStack(Material.RED_STAINED_GLASS_PANE);
        ItemMeta meta = item.getItemMeta();
        meta.itemName((Component)Component.text((String)"Previous page", (TextColor)NamedTextColor.RED));
        item.setItemMeta(meta);
        return item;
    }

    public ItemStack getItemNextPage() {
        ItemStack item = new ItemStack(Material.GREEN_STAINED_GLASS_PANE);
        ItemMeta meta = item.getItemMeta();
        meta.itemName((Component)Component.text((String)"Next page", (TextColor)NamedTextColor.GREEN));
        item.setItemMeta(meta);
        return item;
    }
}

