/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skywars;

import me.tomqnto.skywars.Message;
import me.tomqnto.skywars.configs.LevelsConfig;
import me.tomqnto.skywars.configs.PlayerConfig;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class PlayerUtils {
    public static void attemptLevelUp(Player player) {
        int xpRequired;
        int xp = PlayerConfig.getXp(player);
        int level = PlayerConfig.getLevel(player);
        try {
            xpRequired = LevelsConfig.getXp(level + 1);
        }
        catch (Exception e) {
            return;
        }
        if (xp < xpRequired) {
            return;
        }
        player.sendRichMessage("<yellow>You leveled up! Now level <gold>" + ++level);
        player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
        PlayerConfig.setXp(player, xp -= xpRequired);
        PlayerConfig.addLevel(player);
        PlayerUtils.attemptLevelUp(player);
    }

    public static void addXp(Player player, int amount, Message message) {
        PlayerConfig.addXp(player, amount);
        player.sendRichMessage(message.setPlaceholders(new TagResolver[]{Placeholder.unparsed((String)"amount", (String)String.valueOf(amount))}));
        PlayerUtils.attemptLevelUp(player);
    }

    public static void displayProgressBar(Player player) {
        int currentXp = PlayerConfig.getXp(player);
        int currentLevel = PlayerConfig.getLevel(player);
        int nextLevelXp = LevelsConfig.getXp(currentLevel + 1);
        int barLength = 20;
        int progress = (int)((double)currentXp / (double)nextLevelXp * (double)barLength);
        String bar = "<green>\u2588".repeat(progress) + "<gray>\u2588".repeat(barLength - progress);
        player.sendRichMessage("<gold>Progress: <yellow>%s<gray>/<yellow>%s".formatted(currentXp, nextLevelXp));
        player.sendRichMessage("    <dark_gray><bold>[</bold>" + bar + "<bold><dark_gray>]");
    }

    public static void teleport(Player player, Location location) {
        player.setVelocity(new Vector(0, 0, 0));
        player.teleport(location);
    }

    public static void refreshPlayer(Player player) {
        player.getInventory().clear();
        player.setHealth(20.0);
        player.setFoodLevel(20);
        player.setSaturation(6.0f);
        player.setExperienceLevelAndProgress(0);
        player.clearActivePotionEffects();
        player.setGameMode(GameMode.SURVIVAL);
    }
}

