/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skywars;

import java.util.HashMap;
import me.tomqnto.skywars.Metrics;
import me.tomqnto.skywars.command.SkyWarsPlusCommand;
import me.tomqnto.skywars.configs.GameConfigurationManager;
import me.tomqnto.skywars.configs.JoinMenuConfig;
import me.tomqnto.skywars.configs.KillMessagesConfig;
import me.tomqnto.skywars.configs.LevelsConfig;
import me.tomqnto.skywars.configs.LootItemsConfig;
import me.tomqnto.skywars.configs.MapConfig;
import me.tomqnto.skywars.configs.MessagesConfig;
import me.tomqnto.skywars.configs.PlayerConfig;
import me.tomqnto.skywars.configs.PluginConfigManager;
import me.tomqnto.skywars.configs.SkyWarsMenuConfig;
import me.tomqnto.skywars.configs.StatsMenuConfig;
import me.tomqnto.skywars.game.Game;
import me.tomqnto.skywars.game.GameConfiguration;
import me.tomqnto.skywars.game.GameManager;
import me.tomqnto.skywars.game.GameMap;
import me.tomqnto.skywars.listeners.GameListeners;
import me.tomqnto.skywars.listeners.LobbyListeners;
import me.tomqnto.skywars.listeners.OtherListeners;
import me.tomqnto.skywars.menus.api.MenuListeners;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class SkywarsPlus
extends JavaPlugin {
    private static SkywarsPlus instance;
    public static final HashMap<Player, GameMap> viewingMaps;

    public void onLoad() {
        instance = this;
    }

    public void onEnable() {
        ConfigurationSerialization.registerClass(GameConfiguration.class);
        SkywarsPlus.loadConfigs();
        GameManager gameManager = new GameManager();
        this.getServer().getPluginManager().registerEvents((Listener)new GameListeners(gameManager), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new LobbyListeners(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new OtherListeners(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new MenuListeners(), (Plugin)this);
        this.getCommand("skywarsplus").setExecutor((CommandExecutor)new SkyWarsPlusCommand(gameManager));
        Metrics metrics = new Metrics((Plugin)this, 27132);
    }

    public static SkywarsPlus getInstance() {
        return instance;
    }

    public void onDisable() {
        GameManager.games.values().forEach(Game::deleteGame);
        viewingMaps.values().forEach(GameMap::unload);
    }

    public static void loadConfigs() {
        PluginConfigManager.load();
        GameConfigurationManager.load();
        LootItemsConfig.load();
        MapConfig.load();
        JoinMenuConfig.load();
        SkyWarsMenuConfig.load();
        StatsMenuConfig.load();
        PlayerConfig.load();
        KillMessagesConfig.load();
        MessagesConfig.load();
        LevelsConfig.load();
    }

    static {
        viewingMaps = new HashMap();
    }
}

