/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skywars.command.arguments;

import java.util.List;
import me.tomqnto.skywars.Message;
import me.tomqnto.skywars.command.ArgumentExecutor;
import me.tomqnto.skywars.configs.GameConfigurationManager;
import me.tomqnto.skywars.game.GameConfiguration;
import me.tomqnto.skywars.menus.ConfigMenu;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class EditGameConfigArgument
implements ArgumentExecutor {
    @Override
    public void execute(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            Message.PLAYER_ONLY_COMMAND.send(sender);
            return;
        }
        Player player = (Player)sender;
        if (args.length != 2) {
            Message.INVALID_USAGE.send((CommandSender)player, new TagResolver[]{Placeholder.unparsed((String)"usage", (String)this.getUsage())});
            return;
        }
        String configName = args[1];
        List<GameConfiguration> gameConfigList = GameConfigurationManager.getSavedGameConfigurations().stream().filter(config -> config.getName().equals(configName)).toList();
        if (gameConfigList.isEmpty()) {
            Message.send((CommandSender)player, "<red>This config does not exist");
            return;
        }
        GameConfiguration gameConfig = gameConfigList.getFirst();
        new ConfigMenu(configName, gameConfig.getAllowedMapIDs(), true, gameConfig).open(player);
    }

    @Override
    public String getUsage() {
        return "/skywarsplus edit-config <config>";
    }

    @Override
    public String getDescription() {
        return "Opens a menu which allows players to edit an existing game config";
    }
}

