/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skywars.command.arguments;

import java.util.Arrays;
import me.tomqnto.skywars.Message;
import me.tomqnto.skywars.SkywarsPlus;
import me.tomqnto.skywars.command.ArgumentExecutor;
import me.tomqnto.skywars.configs.MapConfig;
import me.tomqnto.skywars.configs.PluginConfigManager;
import me.tomqnto.skywars.game.GameMap;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ViewMapArgument
implements ArgumentExecutor {
    @Override
    public void execute(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            Message.PLAYER_ONLY_COMMAND.send(sender);
            return;
        }
        Player player = (Player)sender;
        if (args.length < 1) {
            Message.INVALID_USAGE.send((CommandSender)player, new TagResolver[]{Placeholder.unparsed((String)"usage", (String)this.getUsage())});
            return;
        }
        if (this.check(player)) {
            Message.send((CommandSender)player, "<red>You are no longer viewing the map: " + SkywarsPlus.viewingMaps.get(player).getName());
            player.teleport(PluginConfigManager.getLobbyLocation());
            SkywarsPlus.viewingMaps.get(player).unload();
            SkywarsPlus.viewingMaps.remove(player);
            return;
        }
        if (args.length == 1) {
            Message.send((CommandSender)player, "<red>You are not editing a map. Use /swp view_map <map_name> first");
            return;
        }
        String[] mapInList = Arrays.copyOfRange(args, 1, args.length);
        StringBuilder builder = new StringBuilder();
        Arrays.stream(mapInList).toList().forEach(arg -> builder.append((String)arg).append(" "));
        String mapName = builder.toString();
        mapName = mapName.stripTrailing();
        if (!MapConfig.getMaps().contains(mapName)) {
            Message.send((CommandSender)player, "<red>The map: " + mapName + " was not found");
            return;
        }
        player.setGameMode(GameMode.CREATIVE);
        Message.send((CommandSender)player, "<green>Teleporting to the map: " + mapName);
        GameMap map = new GameMap(mapName);
        SkywarsPlus.viewingMaps.put(player, map);
        Location loc = map.getSpectatorLocation() == null ? map.getBukkitWorld().getSpawnLocation() : map.getSpectatorLocation();
        NamespacedKey key = new NamespacedKey((Plugin)SkywarsPlus.getInstance(), "viewing_map");
        map.getBukkitWorld().getPersistentDataContainer().set(key, PersistentDataType.BOOLEAN, (Object)true);
        player.teleport(loc);
    }

    @Override
    public String getUsage() {
        return "/skywarsplus view_map <map>";
    }

    @Override
    public String getDescription() {
        return "Creates a temporary world of the selected map and teleports the player";
    }

    private boolean check(Player player) {
        NamespacedKey key = new NamespacedKey((Plugin)SkywarsPlus.getInstance(), "viewing_map");
        return player.getWorld().getPersistentDataContainer().has(key);
    }
}

