/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skywars.configs;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import me.tomqnto.skywars.SkywarsPlus;
import me.tomqnto.skywars.game.GameConfiguration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.Nullable;

public class GameConfigurationManager {
    private static final File file = new File(SkywarsPlus.getInstance().getDataFolder(), "game_configs.yml");
    private static FileConfiguration config;

    public static void load() {
        config = YamlConfiguration.loadConfiguration((File)file);
    }

    public static void saveConfig() {
        try {
            config.save(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        GameConfigurationManager.load();
    }

    public static void saveGameConfiguration(GameConfiguration config) {
        GameConfigurationManager.config.set("game-config." + config.getName(), (Object)config);
        GameConfigurationManager.saveConfig();
    }

    public static void deleteGameConfiguration(String name) {
        config.set("game-config." + name, null);
        GameConfigurationManager.saveConfig();
    }

    @Nullable
    public static GameConfiguration getGameConfiguration(String name) {
        return (GameConfiguration)config.getObject("game-config." + name, GameConfiguration.class);
    }

    public static boolean doesExist(String name) {
        return GameConfigurationManager.getGameConfiguration(name) != null;
    }

    public static Set<GameConfiguration> getSavedGameConfigurations() {
        HashSet<GameConfiguration> configSet = new HashSet<GameConfiguration>();
        ConfigurationSection section = config.getConfigurationSection("game-config");
        if (section == null) {
            return configSet;
        }
        for (String name : section.getKeys(false)) {
            configSet.add(GameConfigurationManager.getGameConfiguration(name));
        }
        return configSet;
    }

    static {
        if (!file.exists()) {
            SkywarsPlus.getInstance().saveResource("game_configs.yml", false);
        }
        GameConfigurationManager.load();
    }
}

