/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skywars.configs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import me.tomqnto.skywars.SkywarsPlus;
import org.bukkit.configuration.file.YamlConfiguration;

public class MapConfig {
    private static final File file = new File(SkywarsPlus.getInstance().getDataFolder(), "map_data.yml");
    private static YamlConfiguration config;

    public static void load() {
        config = YamlConfiguration.loadConfiguration((File)file);
    }

    public static void save() {
        try {
            config.save(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        MapConfig.load();
    }

    public static List<String> getMaps() {
        ArrayList<String> maps = new ArrayList<String>();
        for (String map : config.getKeys(false)) {
            File mapFolder = new File(new File(SkywarsPlus.getInstance().getDataFolder(), "maps"), map);
            if (!mapFolder.exists()) continue;
            maps.add(map);
        }
        return maps;
    }

    public static List<List<Integer>> getOPChestLocations(String map) {
        return (List)config.get(map + ".op-chest-locations");
    }

    public static List<Double> getSpectatorTeleportLocation(String map) {
        return config.getDoubleList(map + ".spectator-teleport-location");
    }

    public static List<List<Double>> getTeamSpawnCoordinates(String map) {
        return (List)config.get(map + ".team-spawn-locations");
    }

    public static String getID(String map) {
        return config.getString(map + ".id");
    }

    public static boolean isMapValid(String map) {
        return MapConfig.getSpectatorTeleportLocation(map) != null && !MapConfig.getSpectatorTeleportLocation(map).isEmpty() && MapConfig.getTeamSpawnCoordinates(map) != null && !MapConfig.getSpectatorTeleportLocation(map).isEmpty() && MapConfig.getOPChestLocations(map) != null;
    }

    public static void createMap(String name) {
        config.set(name + ".spectator-teleport-location", List.of(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0)));
        config.set(name + ".id", (Object)name);
        config.set(name + ".team-spawn-locations", List.of(List.of(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0)), List.of(Double.valueOf(1.0), Double.valueOf(1.0), Double.valueOf(1.0))));
        config.set(name + ".op-chest-locations", List.of());
        MapConfig.save();
    }

    static {
        if (!file.exists()) {
            SkywarsPlus.getInstance().saveResource("map_data.yml", false);
        }
        MapConfig.load();
    }
}

