/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skywars.configs;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import me.tomqnto.skywars.MenuPlaceholders;
import me.tomqnto.skywars.menus.api.Button;
import me.tomqnto.skywars.menus.api.SimpleMenu;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class MenuConfigUtils {
    public static List<Integer> getSlots(FileConfiguration config) {
        ConfigurationSection section = config.getConfigurationSection("buttons");
        assert (section != null);
        Set keys = section.getKeys(false);
        ArrayList<Integer> slots = new ArrayList<Integer>();
        keys.forEach(s -> slots.add(Integer.parseInt(s)));
        return slots;
    }

    public static SimpleMenu.Rows getRows(FileConfiguration config) {
        return SimpleMenu.Rows.valueOf(config.getString("rows"));
    }

    public static String getName(int slot, Player player, FileConfiguration config) {
        String name = config.getString("buttons." + slot + ".name");
        name = MenuPlaceholders.setPlaceholders(player, name);
        return name;
    }

    public static List<String> getLore(int slot, Player player, FileConfiguration config) {
        List lore = config.getStringList("buttons." + slot + ".lore");
        ArrayList<String> newLore = new ArrayList<String>();
        lore.forEach(text -> newLore.add(MenuPlaceholders.setPlaceholders(player, text)));
        return newLore;
    }

    public static Material getMaterial(int slot, FileConfiguration config) {
        return Material.valueOf((String)config.getString("buttons." + slot + ".material"));
    }

    public static boolean hasGlint(int slot, FileConfiguration config) {
        return config.getBoolean("buttons." + slot + ".glint");
    }

    public static String getGameConfig(int slot, FileConfiguration config) {
        return config.getString("buttons." + slot + ".config");
    }

    public static List<Consumer<Player>> getPlayerActions(int slot, FileConfiguration config) {
        List actionsStr = config.getStringList("buttons." + slot + ".actions");
        ArrayList<Consumer<Player>> actions = new ArrayList<Consumer<Player>>();
        for (String action : actionsStr) {
            if (!action.startsWith("[COMMAND] ")) continue;
            String finalAction = action = action.replace("[COMMAND] ", "");
            actions.add(player -> player.performCommand(MenuPlaceholders.setPlaceholders(player, finalAction)));
        }
        return actions;
    }

    public static List<Consumer<ConsoleCommandSender>> getConsoleActions(int slot, Player player, FileConfiguration config) {
        List actionsStr = config.getStringList("buttons." + slot + ".actions");
        ArrayList<Consumer<ConsoleCommandSender>> actions = new ArrayList<Consumer<ConsoleCommandSender>>();
        for (String action : actionsStr) {
            if (!action.startsWith("[CONSOLE] ")) continue;
            String finalAction = action = action.replace("[CONSOLE] ", "");
            actions.add(sender -> Bukkit.dispatchCommand((CommandSender)sender, (String)MenuPlaceholders.setPlaceholders(player, finalAction)));
        }
        return actions;
    }

    public static List<String> getMessages(int slot, Player player, FileConfiguration config) {
        List actionsStr = config.getStringList("buttons." + slot + ".actions");
        ArrayList<String> msgs = new ArrayList<String>();
        for (String msg : actionsStr) {
            if (!msg.startsWith("[MESSAGE] ")) continue;
            msg = msg.replace("[MESSAGE] ", "");
            msg = MenuPlaceholders.setPlaceholders(player, msg);
            msgs.add(msg);
        }
        return msgs;
    }

    public static void performPlayerActions(int slot, Player player, FileConfiguration config) {
        for (Consumer<Player> action : MenuConfigUtils.getPlayerActions(slot, config)) {
            action.accept(player);
        }
    }

    public static void performConsoleActions(int slot, ConsoleCommandSender sender, Player player, FileConfiguration config) {
        for (Consumer<ConsoleCommandSender> action : MenuConfigUtils.getConsoleActions(slot, player, config)) {
            action.accept(sender);
        }
    }

    public static void sendMessages(int slot, Player player, FileConfiguration config) {
        MenuConfigUtils.getMessages(slot, player, config).forEach(msg -> player.sendMessage((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(msg)));
    }

    public static Button getButton(int slot, Player player, FileConfiguration config) {
        String name = MenuConfigUtils.getName(slot, player, config);
        List<String> loreString = MenuConfigUtils.getLore(slot, player, config);
        Material material = MenuConfigUtils.getMaterial(slot, config);
        boolean glint = MenuConfigUtils.hasGlint(slot, config);
        String gameConfig = MenuConfigUtils.getGameConfig(slot, config);
        if (material == null) {
            return null;
        }
        LegacyComponentSerializer serializer = LegacyComponentSerializer.legacyAmpersand();
        ArrayList lore = new ArrayList();
        loreString.forEach(string -> lore.add(serializer.deserialize(string).decoration(TextDecoration.ITALIC, false)));
        TextComponent buttonName = serializer.deserialize(name);
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.itemName((Component)buttonName);
        meta.lore(lore);
        if (glint) {
            meta.setEnchantmentGlintOverride(Boolean.valueOf(true));
        }
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ADDITIONAL_TOOLTIP});
        item.setItemMeta(meta);
        Consumer<Player> action = player1 -> {
            MenuConfigUtils.performPlayerActions(slot, player1, config);
            MenuConfigUtils.performConsoleActions(slot, Bukkit.getConsoleSender(), player, config);
            MenuConfigUtils.sendMessages(slot, player1, config);
        };
        return new Button(item, action, player1 -> {}, player1 -> {}, player1 -> {}, player1 -> {});
    }
}

