/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skywars.configs;

import java.io.File;
import java.io.IOException;
import me.tomqnto.skywars.SkywarsPlus;
import me.tomqnto.skywars.game.GameConfiguration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class PlayerConfig {
    private static final File file = new File(SkywarsPlus.getInstance().getDataFolder(), "player_data.yml");
    private static FileConfiguration config;

    public static void load() {
        config = YamlConfiguration.loadConfiguration((File)file);
    }

    public static void save() {
        try {
            config.save(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static int getKills(Player player, GameConfiguration gameConfig) {
        return config.getInt(player.getName() + ".stats.%s.kills".formatted(gameConfig.getName()));
    }

    public static int getWins(Player player, GameConfiguration gameConfig) {
        return config.getInt(player.getName() + ".stats.%s.wins".formatted(gameConfig.getName()));
    }

    public static int getLosses(Player player, GameConfiguration gameConfig) {
        return config.getInt(player.getName() + ".stats.%s.losses".formatted(gameConfig.getName()));
    }

    public static int getDeaths(Player player, GameConfiguration gameConfig) {
        return config.getInt(player.getName() + ".stats.%s.deaths".formatted(gameConfig.getName()));
    }

    public static int getWinStreak(Player player, GameConfiguration gameConfig) {
        return config.getInt(player.getName() + ".stats.%s.win-streak".formatted(gameConfig.getName()));
    }

    public static void addKill(Player player, GameConfiguration gameConfig) {
        config.set(player.getName() + ".stats.%s.kills".formatted(gameConfig.getName()), (Object)(PlayerConfig.getKills(player, gameConfig) + 1));
        PlayerConfig.save();
    }

    public static void addWin(Player player, GameConfiguration gameConfig) {
        config.set(player.getName() + ".stats.%s.wins".formatted(gameConfig.getName()), (Object)(PlayerConfig.getWins(player, gameConfig) + 1));
        PlayerConfig.addWinStreak(player, gameConfig);
        PlayerConfig.save();
    }

    public static void addLoss(Player player, GameConfiguration gameConfig) {
        config.set(player.getName() + ".stats.%s.losses".formatted(gameConfig.getName()), (Object)(PlayerConfig.getLosses(player, gameConfig) + 1));
        PlayerConfig.resetWinStreak(player, gameConfig);
        PlayerConfig.save();
    }

    public static void addDeath(Player player, GameConfiguration gameConfig) {
        config.set(player.getName() + ".stats.%s.deaths".formatted(gameConfig.getName()), (Object)(PlayerConfig.getDeaths(player, gameConfig) + 1));
        PlayerConfig.save();
    }

    public static void addWinStreak(Player player, GameConfiguration gameConfig) {
        config.set(player.getName() + ".stats.%s.win-streak".formatted(gameConfig.getName()), (Object)(PlayerConfig.getWinStreak(player, gameConfig) + 1));
        PlayerConfig.save();
    }

    public static void resetWinStreak(Player player, GameConfiguration gameConfig) {
        config.set(player.getName() + ".stats.%s.win-streak".formatted(gameConfig.getName()), (Object)0);
        PlayerConfig.save();
    }

    public static String getKillMessageKey(Player player) {
        return config.getString(player.getName() + ".settings.kill-message-key");
    }

    public static void setKillMessageKey(Player player, String key) {
        config.set(player.getName() + ".settings.kill-message-key", (Object)key);
        PlayerConfig.save();
    }

    public static int getXp(Player player) {
        return config.getInt(player.getName() + ".progress.xp");
    }

    public static void addXp(Player player, int amount) {
        config.set(player.getName() + ".progress.xp", (Object)(PlayerConfig.getXp(player) + amount));
        PlayerConfig.save();
    }

    public static void setXp(Player player, int xp) {
        config.set(player.getName() + ".progress.xp", (Object)xp);
        PlayerConfig.save();
    }

    public static int getLevel(Player player) {
        return config.getInt(player.getName() + ".progress.level");
    }

    public static void setLevel(Player player, int level) {
        config.set(player.getName() + ".progress.level", (Object)level);
        PlayerConfig.save();
    }

    public static void addLevel(Player player) {
        PlayerConfig.setLevel(player, PlayerConfig.getLevel(player) + 1);
        PlayerConfig.save();
    }

    static {
        if (!file.exists()) {
            SkywarsPlus.getInstance().saveResource("player_data.yml", false);
        }
        PlayerConfig.load();
    }
}

