/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skywars.game;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import me.tomqnto.skywars.Message;
import me.tomqnto.skywars.PlayerUtils;
import me.tomqnto.skywars.SkywarsPlus;
import me.tomqnto.skywars.configs.PlayerConfig;
import me.tomqnto.skywars.configs.PluginConfigManager;
import me.tomqnto.skywars.game.ChestManager;
import me.tomqnto.skywars.game.GameConfiguration;
import me.tomqnto.skywars.game.GameManager;
import me.tomqnto.skywars.game.GameMap;
import me.tomqnto.skywars.game.GameScoreboard;
import me.tomqnto.skywars.game.GameState;
import me.tomqnto.skywars.game.GameTeam;
import me.tomqnto.skywars.game.PlayerSession;
import me.tomqnto.skywars.tasks.ChestRefillCountdown;
import me.tomqnto.skywars.tasks.EndCountdown;
import me.tomqnto.skywars.tasks.StartCountdown;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.Nullable;

public class Game {
    private final GameConfiguration gameConfiguration;
    private final GameManager gameManager;
    private final GameMap map;
    private final ChestManager chestManager;
    private GameState gameState;
    private final String id;
    private final HashMap<Player, PlayerSession> gamePlayers;
    private final Set<GameTeam> gameTeams;
    private final StartCountdown startCountdown;
    private final ChestRefillCountdown chestRefillCountdown;
    private final HashSet<Player> alivePlayers;
    private final HashSet<Player> deadPlayers;
    private final HashMap<GameTeam, Location> teamSpawnLocations;
    private final int minPlayers;
    private final int maxPlayers;
    private final Set<Player> spectators;
    private final HashMap<GameTeam, Boolean> teamAliveMap;
    private final HashMap<Player, List<Player>> hiddenPlayers;
    private final GameScoreboard gameScoreboard;
    private final HashMap<Player, Integer> kills;
    private final MiniMessage mm = MiniMessage.miniMessage();

    public Game(GameConfiguration gameConfiguration, GameManager gameManager, GameMap map) {
        int x;
        this.gameConfiguration = gameConfiguration;
        this.gameManager = gameManager;
        this.map = map;
        this.chestManager = new ChestManager(this);
        this.gameState = GameState.WAITING;
        this.id = GameManager.generateID();
        this.gamePlayers = new HashMap();
        this.startCountdown = new StartCountdown(this);
        this.chestRefillCountdown = new ChestRefillCountdown(this);
        this.maxPlayers = gameConfiguration.getMaxTeams() * gameConfiguration.getTeamSize();
        this.minPlayers = gameConfiguration.getMinTeams() * gameConfiguration.getTeamSize();
        this.gameTeams = new HashSet<GameTeam>();
        this.teamSpawnLocations = new HashMap();
        this.alivePlayers = new HashSet();
        this.deadPlayers = new HashSet();
        this.spectators = new HashSet<Player>();
        this.teamAliveMap = new HashMap();
        this.gameScoreboard = new GameScoreboard(this, gameManager);
        this.hiddenPlayers = new HashMap();
        this.kills = new HashMap();
        for (x = 0; x < gameConfiguration.getMaxTeams(); ++x) {
            GameTeam team = new GameTeam(new Player[0]);
            this.gameTeams.add(team);
            this.teamAliveMap.put(team, true);
        }
        for (x = 0; x < gameConfiguration.getMaxTeams(); ++x) {
            this.teamSpawnLocations.put((GameTeam)this.gameTeams.stream().toList().get(x), map.getTeamSpawnLocations().get(x));
        }
        this.startCountdown.runTaskTimer((Plugin)SkywarsPlus.getInstance(), 0L, 20L);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this.chestManager, (Plugin)SkywarsPlus.getInstance());
        if (map.getTeamSpawnLocations().size() < this.gameTeams.size()) {
            SkywarsPlus.getInstance().getLogger().warning("Not enough team locations in the map: %s, config: %s".formatted(map.getName(), gameConfiguration.getName()));
        }
        this.spawnCages();
    }

    public void playerJoin(Player player) {
        if (this.hasStarted()) {
            if (this.isActive()) {
                Message.send((CommandSender)player, "<gray>This game already started");
            } else {
                Message.send((CommandSender)player, "<gray>This game already ended");
            }
            return;
        }
        Message.send((CommandSender)player, "<gray>Joined %s".formatted(this.id));
        PlayerUtils.refreshPlayer(player);
        PlayerSession session = this.gameManager.createPlayerSession(player, this);
        this.gamePlayers.put(player, session);
        this.alivePlayers.add(player);
        player.teleport(this.map.getSpectatorLocation());
        this.assignTeam(player);
        this.teleportToTeamSpawnLocation(player);
        this.gameScoreboard.createScoreboard(player);
        this.broadcastMessage(Message.PLAYER_JOINED_GAME.setPlaceholders(new TagResolver[]{Placeholder.unparsed((String)"player", (String)player.getName()), Placeholder.unparsed((String)"player-count", (String)String.valueOf(this.getPlayerCount())), Placeholder.unparsed((String)"max-players", (String)String.valueOf(this.maxPlayers))}));
        if (this.isWaiting()) {
            if (this.getPlayerCount() == this.minPlayers) {
                this.setGameState(GameState.STARTING);
            }
            if (this.getPlayerCount() == this.maxPlayers) {
                this.setGameState(GameState.STARTING);
                this.startCountdown.setTime(20);
            }
        }
        this.updateScoreboardPlayerCount();
    }

    public void playerLeave(Player player) {
        this.showSpectators(player);
        if (!this.hasStarted()) {
            this.getTeam(player).removePlayer(player);
            this.gamePlayers.remove(player);
            this.alivePlayers.remove(player);
            this.broadcastMessage(Message.PLAYER_LEFT_GAME.setPlaceholders(new TagResolver[]{Placeholder.unparsed((String)"player", (String)player.getName()), Placeholder.unparsed((String)"player-count", (String)String.valueOf(this.getPlayerCount())), Placeholder.unparsed((String)"max-players", (String)String.valueOf(this.maxPlayers))}));
        } else if (this.isActive()) {
            if (this.deadPlayers.contains(player)) {
                this.removeSpectator(player);
            } else {
                this.broadcastMessage(Message.PLAYER_QUIT_GAME.setPlaceholders(new TagResolver[]{Placeholder.unparsed((String)"player", (String)player.getName()), Placeholder.unparsed((String)"player-count", (String)String.valueOf(this.getPlayerCount())), Placeholder.unparsed((String)"max-players", (String)String.valueOf(this.maxPlayers))}));
                player.setHealth(0.0);
                this.removeSpectator(player);
            }
        }
        this.gameManager.deletePlayerSession(player);
        PlayerUtils.refreshPlayer(player);
        PlayerUtils.teleport(player, this.gameManager.getLobbyLocation());
        player.clearTitle();
        this.gameScoreboard.removeScoreboard(player);
        if (this.isStarting() && this.getPlayerCount() < this.minPlayers) {
            this.setGameState(GameState.WAITING);
        }
        this.updateScoreboardPlayerCount();
        if (this.getPlayerCount() == 0) {
            this.deleteGame();
        }
    }

    public void playerDie(Player player) {
        if (this.spectators.contains(player)) {
            return;
        }
        PlayerSession session = this.gameManager.getPlayerSession(player);
        session.markAsDead();
        this.alivePlayers.remove(player);
        this.deadPlayers.add(player);
        this.addSpectator(player);
        if (!this.isTeamAlive(this.getTeam(player))) {
            this.teamAliveMap.put(this.getTeam(player), false);
        }
        this.updateScoreboardPlayersLeft();
        this.updateScoreboardTeamsLeft();
        if (this.getAliveTeams().size() == 1) {
            this.setGameState(GameState.ENDED);
        }
    }

    public void updateScoreboardPlayersLeft() {
        this.getInGamePlayers().forEach(this.gameScoreboard::updatePlayersLeft);
    }

    public void updateScoreboardTeamsLeft() {
        this.getInGamePlayers().forEach(this.gameScoreboard::updateTeamsLeft);
    }

    public void updateScoreboardPlayerCount() {
        this.getInGamePlayers().forEach(this.gameScoreboard::updatePlayerCount);
    }

    public void updateScoreboardChestRefill() {
        this.getInGamePlayers().forEach(this.gameScoreboard::updateChestRefill);
    }

    public void updateScoreboardStartCountdown() {
        this.getInGamePlayers().forEach(this.gameScoreboard::updateStartCountdown);
    }

    public boolean isAlive(Player player) {
        return this.alivePlayers.contains(player);
    }

    @Nullable
    public GameTeam getTeamWon() {
        if (this.getAliveTeams().size() != 1) {
            return null;
        }
        return (GameTeam)this.getAliveTeams().stream().toList().getFirst();
    }

    public Set<Player> getDeadPlayers() {
        return this.deadPlayers;
    }

    public void broadcastMessage(String message) {
        for (Player player : this.getInGamePlayers()) {
            player.sendRichMessage(message);
        }
    }

    public void broadcastMessage(Component component) {
        for (Player player : this.getInGamePlayers()) {
            player.sendMessage(component);
        }
    }

    public void broadcastTitle(Component title, Component subtitle, Duration fadeIn, Duration stay, Duration fadeOut, @Nullable Collection<Player> players) {
        List<Object> playerList = players == null ? this.getInGamePlayers().stream().toList() : players.stream().toList();
        for (Player player : playerList) {
            player.showTitle(Title.title((Component)title, (Component)subtitle, (Title.Times)Title.Times.times((Duration)fadeIn, (Duration)stay, (Duration)fadeOut)));
        }
    }

    public void broadcastTitle(Component title, Component subtitle, @Nullable Collection<Player> players) {
        List<Object> playerList = players == null ? this.getInGamePlayers().stream().toList() : players.stream().toList();
        for (Player player : playerList) {
            player.showTitle(Title.title((Component)title, (Component)subtitle));
        }
    }

    public GameConfiguration getGameConfiguration() {
        return this.gameConfiguration;
    }

    public GameState getGameState() {
        return this.gameState;
    }

    public void setGameState(GameState newState) {
        GameState before = this.gameState;
        this.gameState = newState;
        this.gameManager.getGamesMenu().update();
        if (before == GameState.STARTING && newState == GameState.WAITING) {
            this.broadcastMessage("<gray>Not enough players to start");
            this.startCountdown.setTime(40);
        }
        switch (newState) {
            case STARTED: {
                this.gameTeams.forEach(team -> {
                    if (!this.isTeamAlive((GameTeam)team)) {
                        this.teamAliveMap.remove(team);
                    }
                });
                this.removeCages();
                this.chestRefillCountdown.runTaskTimer((Plugin)SkywarsPlus.getInstance(), 0L, 20L);
                this.getInGamePlayers().forEach(player -> {
                    this.hiddenPlayers.put((Player)player, new ArrayList());
                    this.gameScoreboard.registerStartedTeams((Player)player);
                });
                for (Player player2 : this.gamePlayers.keySet()) {
                    this.kills.put(player2, 0);
                    player2.addPotionEffect(new PotionEffect(PotionEffectType.RESISTANCE, 60, 10));
                }
                break;
            }
            case ENDED: {
                new EndCountdown(this).runTaskTimer((Plugin)SkywarsPlus.getInstance(), 0L, 20L);
                HashSet<Player> lost = new HashSet<Player>();
                this.getGameTeams().forEach(team -> {
                    if (team != this.getTeamWon()) {
                        lost.addAll(team.getTeamPlayers());
                    }
                });
                lost.retainAll(this.spectators);
                HashSet<Player> others = new HashSet<Player>(this.spectators);
                others.removeAll(lost);
                others.removeAll(this.getTeamWon().getTeamPlayers());
                this.broadcastTitle(this.mm.deserialize((Object)Message.VICTORY_TITLE.text()), this.mm.deserialize((Object)Message.VICTORY_SUBTITLE.text()), this.getTeamWon().getTeamPlayers());
                this.broadcastTitle(this.mm.deserialize((Object)Message.GAME_ENDED_TITLE.text()), this.mm.deserialize((Object)Message.GAME_ENDED_SUBTITLE.text()), others);
                this.broadcastTitle(this.mm.deserialize((Object)Message.LOST_TITLE.text()), this.mm.deserialize((Object)Message.LOST_SUBTITLE.text()), lost);
                this.getInGamePlayers().forEach(this.gameScoreboard::removeScoreboard);
                this.getTeamWon().getTeamPlayers().forEach(player -> {
                    PlayerConfig.addWin(player, this.gameConfiguration);
                    PlayerUtils.addXp(player, this.gameConfiguration.getXpPerWin(), Message.WIN_XP_GAINED);
                    PlayerUtils.displayProgressBar(player);
                });
                lost.forEach(PlayerUtils::displayProgressBar);
                this.getDeadTeams().forEach(team -> team.getTeamPlayers().forEach(player -> PlayerConfig.addLoss(player, this.gameConfiguration)));
            }
        }
    }

    public GameMap getMap() {
        return this.map;
    }

    public String getId() {
        return this.id;
    }

    public HashMap<Player, PlayerSession> getGamePlayers() {
        return this.gamePlayers;
    }

    public int getPlayerCount() {
        return this.gamePlayers.size();
    }

    public void deleteGame() {
        this.map.getBukkitWorld().getPlayers().forEach(player -> {
            this.gameManager.deletePlayerSession((Player)player);
            this.gameScoreboard.removeScoreboard((Player)player);
            PlayerUtils.refreshPlayer(player);
            player.setGameMode(GameMode.SURVIVAL);
            player.teleport(this.gameManager.getLobbyLocation());
            this.showSpectators((Player)player);
            if (this.isSpectator((Player)player)) {
                this.removeSpectator((Player)player);
            }
        });
        this.map.unload();
        this.gameManager.getGames().remove(this.id);
    }

    public void assignTeam(Player player) {
        List<GameTeam> teams = this.gameTeams.stream().filter(team -> team.getPlayerCount() < this.gameConfiguration.getTeamSize()).toList();
        if (teams.isEmpty()) {
            this.playerLeave(player);
            Message.send((CommandSender)player, "<red>You were kicked: not enough teams to join");
        } else {
            teams.getFirst().addPlayer(player);
        }
    }

    public StartCountdown getStartCountdown() {
        return this.startCountdown;
    }

    public ChestManager getChestManager() {
        return this.chestManager;
    }

    public HashSet<Player> getAlivePlayers() {
        return this.alivePlayers;
    }

    public Set<GameTeam> getGameTeams() {
        return this.gameTeams;
    }

    public int getMinPlayers() {
        return this.minPlayers;
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    public HashMap<GameTeam, Location> getTeamSpawnLocations() {
        return this.teamSpawnLocations;
    }

    public GameTeam getTeam(Player player) {
        for (GameTeam team : this.gameTeams) {
            if (!team.getTeamPlayers().contains(player)) continue;
            return team;
        }
        return null;
    }

    public void teleportToTeamSpawnLocations() {
        for (Player player : this.gamePlayers.keySet()) {
            this.teleportToTeamSpawnLocation(player);
        }
    }

    public void teleportToTeamSpawnLocation(Player player) {
        player.teleport(this.teamSpawnLocations.get(this.getTeam(player)));
    }

    public void setCages(Material material) {
        int size = 1;
        int start = -2;
        for (GameTeam team : this.gameTeams) {
            Location center = this.getTeamSpawnLocations().get(team).clone();
            for (int x = start; x <= size; ++x) {
                for (int y = -1; y <= size + 2; ++y) {
                    for (int z = start; z <= size; ++z) {
                        boolean isEdge;
                        Location loc = center.clone().add((double)x, (double)y, (double)z);
                        Block block = loc.getBlock();
                        boolean bl = isEdge = x == start || x == size || y == -1 || y == size + 2 || z == start || z == size;
                        if (isEdge) {
                            block.setType(material);
                            continue;
                        }
                        block.setType(Material.AIR);
                    }
                }
            }
        }
    }

    public void spawnCages() {
        this.setCages(PluginConfigManager.getCageMaterial());
    }

    public void removeCages() {
        this.setCages(Material.AIR);
    }

    public Set<Player> getSpectators() {
        return this.spectators;
    }

    public Set<Player> getInGamePlayers() {
        HashSet<Player> players = new HashSet<Player>();
        players.addAll(this.getAlivePlayers());
        players.addAll(this.getSpectators());
        return players;
    }

    public Set<GameTeam> getAliveTeams() {
        return this.teamAliveMap.keySet().stream().filter(this.teamAliveMap::get).collect(Collectors.toSet());
    }

    public Set<GameTeam> getDeadTeams() {
        return this.teamAliveMap.keySet().stream().filter(team -> this.teamAliveMap.get(team) == false).collect(Collectors.toSet());
    }

    public boolean isTeamAlive(GameTeam team) {
        if (team.getPlayerCount() == 0) {
            return false;
        }
        return !this.deadPlayers.containsAll(team.getTeamPlayers());
    }

    public void addSpectator(Player player) {
        player.setCollidable(false);
        player.setGameMode(GameMode.CREATIVE);
        GameManager.getSpectatorTeam().addPlayer((OfflinePlayer)player);
        if (!this.hiddenPlayers.containsKey(player)) {
            this.hiddenPlayers.put(player, List.of());
        }
        this.hiddenPlayers.keySet().forEach(inGamePlayer -> {
            if (inGamePlayer == player) {
                return;
            }
            inGamePlayer.hidePlayer((Plugin)SkywarsPlus.getInstance(), player);
            List<Player> hidden = this.hiddenPlayers.get(inGamePlayer);
            hidden.add(player);
            this.hiddenPlayers.put((Player)inGamePlayer, hidden);
        });
        this.spectators.add(player);
    }

    public void removeSpectator(Player player) {
        player.setCollidable(true);
        player.setGameMode(GameMode.SURVIVAL);
        GameManager.getSpectatorTeam().removePlayer((OfflinePlayer)player);
        this.hiddenPlayers.keySet().forEach(inGamePlayer -> {
            if (inGamePlayer == player) {
                return;
            }
            inGamePlayer.showPlayer((Plugin)SkywarsPlus.getInstance(), player);
            List<Player> hidden = this.hiddenPlayers.get(inGamePlayer);
            hidden.remove(player);
            this.hiddenPlayers.put((Player)inGamePlayer, hidden);
        });
        this.spectators.remove(player);
    }

    public boolean isSpectator(Player player) {
        return this.spectators.contains(player);
    }

    public void showSpectators(Player player) {
        this.spectators.forEach(spectator -> player.showPlayer((Plugin)SkywarsPlus.getInstance(), spectator));
    }

    public void hideSpectators(Player player) {
        this.spectators.forEach(spectator -> player.hidePlayer((Plugin)SkywarsPlus.getInstance(), spectator));
    }

    public void addKill(Player player) {
        this.kills.put(player, this.kills.get(player) + 1);
    }

    public ChestRefillCountdown getChestRefillCountdown() {
        return this.chestRefillCountdown;
    }

    public GameScoreboard getGameScoreboard() {
        return this.gameScoreboard;
    }

    public boolean hasStarted() {
        return this.gameState == GameState.STARTED || this.gameState == GameState.ENDED;
    }

    public boolean hasEnded() {
        return this.gameState == GameState.ENDED;
    }

    public boolean isWaiting() {
        return this.gameState == GameState.WAITING;
    }

    public boolean isStarting() {
        return this.gameState == GameState.STARTING;
    }

    public boolean isActive() {
        return this.gameState == GameState.STARTED;
    }
}

