/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skywars.game;

import java.util.HashMap;
import java.util.List;
import me.tomqnto.skywars.Message;
import me.tomqnto.skywars.game.Game;
import me.tomqnto.skywars.game.GameConfiguration;
import me.tomqnto.skywars.game.GameManager;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class GameJoinHandler {
    public static void joinGame(Player player, GameConfiguration gameSettings, GameManager gameManager) {
        if (gameManager.hasActiveSession(player)) {
            return;
        }
        HashMap<String, Game> games = gameManager.getGames();
        if (!games.isEmpty()) {
            for (Game game : games.values()) {
                if (gameSettings != game.getGameConfiguration() || game.getPlayerCount() >= game.getMaxPlayers() || game.hasStarted()) continue;
                game.playerJoin(player);
                return;
            }
        } else {
            Game game = gameManager.createGame(gameSettings);
            List<String> maps = GameManager.getValidMaps(gameSettings.getAllowedMapIDs());
            if (maps.isEmpty()) {
                Message.send((CommandSender)player, "<red>No maps available");
                return;
            }
            if (game != null) {
                game.playerJoin(player);
                return;
            }
        }
        Message.send((CommandSender)player, "<red>Could not find a game to join");
    }

    public static void joinGame(Player player, String id, GameManager gameManager) {
        if (!gameManager.getGames().containsKey(id)) {
            Message.send((CommandSender)player, "<red>This game does not exist");
            return;
        }
        Game game = gameManager.getGames().get(id);
        game.playerJoin(player);
    }
}

