/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skywars.listeners;

import com.destroystokyo.paper.event.entity.ThrownEggHatchEvent;
import com.destroystokyo.paper.event.player.PlayerPickupExperienceEvent;
import com.destroystokyo.paper.event.player.PlayerSetSpawnEvent;
import io.papermc.paper.event.player.AsyncChatEvent;
import io.papermc.paper.event.player.PlayerPickItemEvent;
import java.util.Objects;
import me.tomqnto.skywars.Message;
import me.tomqnto.skywars.PlayerUtils;
import me.tomqnto.skywars.SkywarsPlus;
import me.tomqnto.skywars.configs.KillMessagesConfig;
import me.tomqnto.skywars.configs.PlayerConfig;
import me.tomqnto.skywars.game.Game;
import me.tomqnto.skywars.game.GameManager;
import me.tomqnto.skywars.game.PlayerSession;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.server.BroadcastMessageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class GameListeners
implements Listener {
    private final GameManager gameManager;
    private final MiniMessage mm = MiniMessage.miniMessage();

    public GameListeners(GameManager gameManager) {
        this.gameManager = gameManager;
    }

    @EventHandler
    public void onTeleport(PlayerTeleportEvent event) {
        if (this.gameManager.hasActiveSession(event.getPlayer()) && event.getTo().getWorld() != this.gameManager.getPlayerSession(event.getPlayer()).getGame().getMap().getBukkitWorld()) {
            event.setCancelled(true);
            Message.send((CommandSender)event.getPlayer(), "<red>Teleport canceled: Cannot teleport out of the game world");
        }
    }

    @EventHandler
    public void onPlayerLeave(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (this.gameManager.hasActiveSession(player) && this.gameManager.getPlayerSession(player).getGame().isAlive(player)) {
            this.gameManager.getPlayerSession(player).getGame().playerLeave(player);
        }
    }

    @EventHandler
    public void onProjectileHitPlayer(ProjectileHitEvent event) {
        Player player;
        Entity entity;
        if (event.getHitEntity() != null && (entity = event.getHitEntity()) instanceof Player && this.gameManager.hasActiveSession(player = (Player)entity)) {
            ProjectileSource projectileSource;
            Entity shooter;
            if (event.getEntity().getType() == EntityType.SNOWBALL || event.getEntityType() == EntityType.EGG) {
                ProjectileSource projectileSource2 = event.getEntity().getShooter();
                if (projectileSource2 instanceof Entity) {
                    shooter = (Entity)projectileSource2;
                    player.damage(1.0E-4, shooter);
                } else {
                    player.damage(1.0E-4);
                }
                Vector velocity = event.getEntity().getVelocity();
                velocity = velocity.multiply(-0.3);
                player.knockback(0.5, velocity.getX(), velocity.getZ());
            } else if (event.getEntity().getType() == EntityType.ARROW && (projectileSource = event.getEntity().getShooter()) instanceof Entity && (shooter = (Entity)projectileSource) instanceof Player) {
                Player shooterPlayer = (Player)shooter;
                shooterPlayer.playSound(shooterPlayer.getLocation(), Sound.ENTITY_ARROW_HIT_PLAYER, 1.0f, 1.0f);
            }
        }
    }

    @EventHandler
    public void onEggCrack(ThrownEggHatchEvent event) {
        if (event.getEgg().getWorld().getPersistentDataContainer().has(new NamespacedKey((Plugin)SkywarsPlus.getInstance(), "skywars_map"))) {
            event.setHatching(false);
        }
    }

    @EventHandler
    public void onDrinkPotion(PlayerItemConsumeEvent event) {
        if (this.gameManager.hasActiveSession(event.getPlayer()) && event.getItem().getType() == Material.POTION) {
            event.setReplacement(new ItemStack(Material.AIR));
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getPlayer();
        if (this.gameManager.hasActiveSession(player)) {
            Game game = this.gameManager.getPlayerSession(player).getGame();
            player.teleport(game.getMap().getSpectatorLocation());
            if (game.getSpectators().contains(player)) {
                event.setCancelled(true);
                return;
            }
            if (game.isActive()) {
                PlayerConfig.addDeath(player, game.getGameConfiguration());
                Player killer = player.getKiller();
                if (killer != null) {
                    PlayerConfig.addKill(killer, game.getGameConfiguration());
                    game.addKill(killer);
                    game.getGameScoreboard().updateKills(player);
                    this.gameManager.getPlayerSession(player.getKiller()).addKill();
                    String key = PlayerConfig.getKillMessageKey(killer);
                    if (!Objects.equals(key, "null")) {
                        game.broadcastMessage(KillMessagesConfig.getMessage(key, killer.getName(), player.getName()));
                    } else {
                        game.broadcastMessage(((Component)Objects.requireNonNullElse(event.deathMessage(), Component.empty())).color((TextColor)NamedTextColor.GRAY));
                    }
                    PlayerUtils.addXp(killer, game.getGameConfiguration().getXpPerKill(), Message.KILL_XP_GAINED);
                } else {
                    game.broadcastMessage(event.deathMessage());
                }
                game.playerDie(player);
                event.deathMessage((Component)Component.empty());
            } else {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        if (this.gameManager.hasActiveSession(player)) {
            player.setGameMode(GameMode.SURVIVAL);
            event.setRespawnLocation(this.gameManager.getPlayerSession(player).getGame().getMap().getSpectatorLocation());
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        if (this.gameManager.hasActiveSession(player) && !this.gameManager.getPlayerSession(player).getGame().isActive()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        if (this.gameManager.hasActiveSession(player) && !this.gameManager.getPlayerSession(player).getGame().isActive()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (!this.gameManager.hasActiveSession(player)) {
            return;
        }
        Game game = this.gameManager.getPlayerSession(player).getGame();
        if (!game.isActive() || game.isSpectator(player)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerHurt(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!this.gameManager.hasActiveSession(player)) {
            return;
        }
        Game game = this.gameManager.getPlayerSession(player).getGame();
        Entity entity2 = event.getDamageSource().getCausingEntity();
        if (entity2 instanceof Player) {
            Player causedPlayer = (Player)entity2;
            if (game.isSpectator(causedPlayer) || game.getTeam(player) == game.getTeam(causedPlayer)) {
                event.setCancelled(true);
            }
            return;
        }
        if (!game.isActive()) {
            event.setCancelled(true);
        }
        if (game.getSpectators().contains(player)) {
            event.setCancelled(true);
        }
        if (event.getDamageSource().getDamageType() == DamageType.OUT_OF_WORLD) {
            if (game.isWaiting()) {
                event.setCancelled(true);
                player.teleport(game.getMap().getSpectatorLocation());
            } else if (game.isActive()) {
                if (game.getSpectators().contains(player)) {
                    event.setCancelled(true);
                    player.teleport(game.getMap().getSpectatorLocation());
                }
            } else {
                event.setCancelled(true);
                if (game.getTeam(player) != null) {
                    player.teleport(game.getTeamSpawnLocations().get(game.getTeam(player)));
                } else {
                    player.teleport(game.getMap().getSpectatorLocation());
                }
            }
        }
    }

    @EventHandler
    public void onChatEvent(AsyncChatEvent event) {
        Player player = event.getPlayer();
        PlayerSession playerSession = this.gameManager.getPlayerSession(player);
        if (playerSession != null) {
            event.viewers().clear();
            event.viewers().addAll(playerSession.getGame().getGamePlayers().keySet());
            event.renderer((sender, name, message, audience) -> ((TextComponent)Component.text((String)sender.getName(), (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)": "))).append(message.color((TextColor)NamedTextColor.WHITE)));
        } else {
            for (Player p : this.gameManager.getPlayerSessions().keySet()) {
                event.viewers().remove(p);
            }
        }
    }

    @EventHandler
    public void onMessageBroadcast(BroadcastMessageEvent event) {
        event.getRecipients().removeIf(sender -> {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                this.gameManager.hasActiveSession(player);
            }
            return false;
        });
    }

    @EventHandler
    public void onItemPickUp(PlayerPickItemEvent event) {
        Player player = event.getPlayer();
        if (!this.gameManager.hasActiveSession(player)) {
            return;
        }
        PlayerSession session = this.gameManager.getPlayerSession(player);
        if (session.getGame().isSpectator(player) || !session.getGame().isActive()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onItemDrop(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        if (!this.gameManager.hasActiveSession(player)) {
            return;
        }
        PlayerSession session = this.gameManager.getPlayerSession(player);
        if (session.getGame().isSpectator(player)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onExpPickup(PlayerPickupExperienceEvent event) {
        Player player = event.getPlayer();
        if (!this.gameManager.hasActiveSession(player)) {
            return;
        }
        PlayerSession session = this.gameManager.getPlayerSession(player);
        if (session.getGame().isSpectator(player) || !session.getGame().hasStarted()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onRespawnPointSet(PlayerSetSpawnEvent event) {
        if (this.gameManager.hasActiveSession(event.getPlayer())) {
            event.setCancelled(true);
        }
    }
}

