/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skywars.listeners;

import com.destroystokyo.paper.event.player.PlayerPickupExperienceEvent;
import io.papermc.paper.event.player.PlayerPickItemEvent;
import me.tomqnto.skywars.Message;
import me.tomqnto.skywars.configs.PluginConfigManager;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerDropItemEvent;

public class LobbyListeners
implements Listener {
    @EventHandler
    public void onPlayerHurt(EntityDamageEvent event) {
        Player player;
        World world;
        Entity entity = event.getEntity();
        if (entity instanceof Player && (world = (player = (Player)entity).getWorld()) == PluginConfigManager.getLobbyLocation().getWorld()) {
            if (PluginConfigManager.isInvulnerableInLobby()) {
                event.setCancelled(true);
            }
            if (event.getDamageSource().getDamageType() == DamageType.OUT_OF_WORLD) {
                player.teleport(PluginConfigManager.getLobbyLocation());
            }
        }
    }

    @EventHandler
    public void onItemDrop(PlayerDropItemEvent event) {
        World world = event.getPlayer().getWorld();
        if (world == PluginConfigManager.getLobbyLocation().getWorld() && !PluginConfigManager.canDropItemsInLobby()) {
            event.setCancelled(true);
            if (PluginConfigManager.sendActionFailedMessageInLobby()) {
                Message.send((CommandSender)event.getPlayer(), "<red>Cannot drop items in the lobby");
            }
        }
    }

    @EventHandler
    public void onItemPick(PlayerPickItemEvent event) {
        World world = event.getPlayer().getWorld();
        if (world == PluginConfigManager.getLobbyLocation().getWorld() && !PluginConfigManager.getCanPickUpItemsInLobby()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlaceBlock(BlockPlaceEvent event) {
        World world = event.getPlayer().getWorld();
        if (world == PluginConfigManager.getLobbyLocation().getWorld() && !PluginConfigManager.canPlaceBlocksInLobby()) {
            event.setCancelled(true);
            if (PluginConfigManager.sendActionFailedMessageInLobby()) {
                Message.send((CommandSender)event.getPlayer(), "<red>Cannot place blocks in the lobby");
            }
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        World world = event.getPlayer().getWorld();
        if (world == PluginConfigManager.getLobbyLocation().getWorld() && !PluginConfigManager.canBreakBlocksInLobby()) {
            event.setCancelled(true);
            if (PluginConfigManager.sendActionFailedMessageInLobby()) {
                Message.send((CommandSender)event.getPlayer(), "<red>Cannot break blocks in the lobby");
            }
        }
    }

    @EventHandler
    public void onExpPickup(PlayerPickupExperienceEvent event) {
        World world = event.getPlayer().getWorld();
        if (world == PluginConfigManager.getLobbyLocation().getWorld() && !PluginConfigManager.canPickupExpOrbsInLobby()) {
            event.setCancelled(true);
        }
    }
}

