/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skywars.menus;

import java.util.List;
import me.tomqnto.skywars.Message;
import me.tomqnto.skywars.configs.GameConfigurationManager;
import me.tomqnto.skywars.game.GameConfiguration;
import me.tomqnto.skywars.menus.api.Button;
import me.tomqnto.skywars.menus.api.SimpleMenu;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Nullable;

public class ConfigMenu
extends SimpleMenu {
    private final String name;
    private final String[] mapIds;
    private final boolean editMode;
    private int minTeams = 8;
    private int maxTeams = 12;
    private int teamSize = 1;
    private int maxArmorNormal = 2;
    private int maxArmorOP = 1;
    private int chestRefill = 120;
    private int xpPerKill = 1;
    private int xpPerWin = 10;
    private final Component increaseByOne = Component.text((String)"[LEFT-CLICK] +1", (TextColor)NamedTextColor.GREEN).decoration(TextDecoration.ITALIC, false);
    private final Component increaseByFive = Component.text((String)"[SHIFT LEFT-CLICK] +5", (TextColor)NamedTextColor.GREEN).decoration(TextDecoration.ITALIC, false);
    private final Component decreaseByOne = Component.text((String)"[RIGHT-CLICK] -1", (TextColor)NamedTextColor.RED).decoration(TextDecoration.ITALIC, false);
    private final Component decreaseByFive = Component.text((String)"[SHIFT RIGHT-CLICK] -5", (TextColor)NamedTextColor.RED).decoration(TextDecoration.ITALIC, false);

    public ConfigMenu(String name, String[] mapIds, boolean editMode, @Nullable GameConfiguration gameConfig) {
        super(SimpleMenu.Rows.SIX, (Component)Component.text((String)("Config: " + name)));
        this.name = name;
        this.mapIds = mapIds;
        this.editMode = editMode;
        if (gameConfig != null) {
            this.minTeams = gameConfig.getMinTeams();
            this.maxTeams = gameConfig.getMaxTeams();
            this.teamSize = gameConfig.getTeamSize();
            this.maxArmorNormal = gameConfig.getMaxArmorPiecesNormalChest();
            this.maxArmorOP = gameConfig.getMaxArmorPiecesOPChest();
            this.chestRefill = gameConfig.getChestRefillCooldown();
            this.xpPerKill = gameConfig.getXpPerKill();
            this.xpPerWin = gameConfig.getXpPerWin();
        }
    }

    @Override
    public void onSetup() {
        ItemStack minTeamItem = new ItemStack(Material.LEATHER_HELMET);
        ItemMeta minTeamMeta = minTeamItem.getItemMeta();
        minTeamMeta.itemName(Component.text((String)("Min Teams: " + this.minTeams), (TextColor)NamedTextColor.GOLD).decoration(TextDecoration.ITALIC, false));
        minTeamMeta.lore(List.of(Component.empty().decoration(TextDecoration.ITALIC, false), this.increaseByOne, this.decreaseByOne));
        minTeamItem.setItemMeta(minTeamMeta);
        ItemStack maxTeamItem = new ItemStack(Material.CHAINMAIL_HELMET);
        ItemMeta maxTeamMeta = maxTeamItem.getItemMeta();
        maxTeamMeta.itemName(Component.text((String)("Max Teams: " + this.maxTeams), (TextColor)NamedTextColor.GOLD).decoration(TextDecoration.ITALIC, false));
        maxTeamMeta.lore(List.of(Component.empty().decoration(TextDecoration.ITALIC, false), this.increaseByOne, this.decreaseByOne));
        maxTeamItem.setItemMeta(maxTeamMeta);
        ItemStack maxArmorNormalItem = new ItemStack(Material.DIAMOND_CHESTPLATE);
        ItemMeta maxArmorNormalMeta = maxArmorNormalItem.getItemMeta();
        maxArmorNormalMeta.itemName(Component.text((String)("Max Armor (Normal Chest): " + this.maxArmorNormal), (TextColor)NamedTextColor.GOLD).decoration(TextDecoration.ITALIC, false));
        maxArmorNormalMeta.lore(List.of(Component.empty().decoration(TextDecoration.ITALIC, false), this.increaseByOne, this.decreaseByOne));
        maxArmorNormalItem.setItemMeta(maxArmorNormalMeta);
        ItemStack maxArmorOPItem = new ItemStack(Material.NETHERITE_CHESTPLATE);
        ItemMeta maxArmorOPMeta = maxArmorOPItem.getItemMeta();
        maxArmorOPMeta.itemName(Component.text((String)("Max Armor (OP Chest): " + this.maxArmorOP), (TextColor)NamedTextColor.GOLD).decoration(TextDecoration.ITALIC, false));
        maxArmorOPMeta.lore(List.of(Component.empty().decoration(TextDecoration.ITALIC, false), this.increaseByOne, this.decreaseByOne));
        maxArmorOPItem.setItemMeta(maxArmorOPMeta);
        ItemStack teamSizeItem = new ItemStack(Material.NETHERITE_SWORD);
        ItemMeta teamSizeMeta = teamSizeItem.getItemMeta();
        teamSizeMeta.itemName(Component.text((String)("Team Size: " + this.teamSize), (TextColor)NamedTextColor.GOLD).decoration(TextDecoration.ITALIC, false));
        teamSizeMeta.lore(List.of(Component.empty().decoration(TextDecoration.ITALIC, false), this.increaseByOne, this.decreaseByOne));
        teamSizeItem.setItemMeta(teamSizeMeta);
        ItemStack chestRefillItem = new ItemStack(Material.CHEST);
        ItemMeta chestRefillMeta = chestRefillItem.getItemMeta();
        chestRefillMeta.itemName(Component.text((String)("Chest Refill Timer: " + this.chestRefill + "s"), (TextColor)NamedTextColor.GOLD).decoration(TextDecoration.ITALIC, false));
        chestRefillMeta.lore(List.of(Component.empty().decoration(TextDecoration.ITALIC, false), this.increaseByOne, this.increaseByFive, Component.empty(), this.decreaseByOne, this.decreaseByFive));
        chestRefillItem.setItemMeta(chestRefillMeta);
        ItemStack killXpItem = new ItemStack(Material.EXPERIENCE_BOTTLE);
        ItemMeta killXpMeta = killXpItem.getItemMeta();
        killXpMeta.itemName(Component.text((String)("XP Per Kill: " + this.xpPerKill + "xp"), (TextColor)NamedTextColor.GOLD).decoration(TextDecoration.ITALIC, false));
        killXpMeta.lore(List.of(Component.empty(), this.increaseByOne, this.increaseByFive, Component.empty(), this.decreaseByOne, this.decreaseByFive, Component.empty()));
        killXpItem.setItemMeta(killXpMeta);
        ItemStack winXpItem = new ItemStack(Material.EXPERIENCE_BOTTLE);
        ItemMeta winXpMeta = winXpItem.getItemMeta();
        winXpMeta.itemName(Component.text((String)("XP Per Win: " + this.xpPerWin + "xp"), (TextColor)NamedTextColor.GOLD).decoration(TextDecoration.ITALIC, false));
        winXpMeta.lore(List.of(Component.empty(), this.increaseByOne, this.increaseByFive, Component.empty(), this.decreaseByOne, this.decreaseByFive, Component.empty()));
        winXpItem.setItemMeta(winXpMeta);
        ItemStack configItem = new ItemStack(Material.HEAVY_CORE);
        ItemMeta configItemMeta = configItem.getItemMeta();
        configItemMeta.itemName(((TextComponent)Component.text((String)"Name: ", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)this.name, (TextColor)NamedTextColor.GREEN))).decoration(TextDecoration.BOLD, false));
        configItemMeta.lore(List.of(Component.empty(), (TextComponent)Component.text((String)"Team Settings:", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, false), (TextComponent)Component.text((String)("  \u2022 Min Teams: " + this.minTeams), (TextColor)NamedTextColor.GREEN).decoration(TextDecoration.ITALIC, false), (TextComponent)Component.text((String)("  \u2022 Max Teams: " + this.maxTeams), (TextColor)NamedTextColor.GREEN).decoration(TextDecoration.ITALIC, false), (TextComponent)Component.text((String)("  \u2022 Team Size: " + this.teamSize), (TextColor)NamedTextColor.GREEN).decoration(TextDecoration.ITALIC, false), Component.empty(), (TextComponent)Component.text((String)"Chest Settings:", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, false), (TextComponent)Component.text((String)("  \u2022 Max Armor (Normal): " + this.maxArmorNormal), (TextColor)NamedTextColor.GREEN).decoration(TextDecoration.ITALIC, false), (TextComponent)Component.text((String)("  \u2022 Max Armor (OP): " + this.maxArmorOP), (TextColor)NamedTextColor.GREEN).decoration(TextDecoration.ITALIC, false), (TextComponent)Component.text((String)("  \u2022 Chest Refill Timer: " + this.chestRefill + "s"), (TextColor)NamedTextColor.GREEN).decoration(TextDecoration.ITALIC, false), (TextComponent)Component.text((String)("  \u2022 XP Per Kill: " + this.xpPerKill + "xp"), (TextColor)NamedTextColor.GREEN).decoration(TextDecoration.ITALIC, false), (TextComponent)Component.text((String)("  \u2022 XP Per Win: " + this.xpPerWin + "xp"), (TextColor)NamedTextColor.GREEN).decoration(TextDecoration.ITALIC, false)));
        configItem.setItemMeta(configItemMeta);
        ItemStack confirm = new ItemStack(Material.LIME_STAINED_GLASS_PANE);
        ItemMeta confirmMeta = confirm.getItemMeta();
        String confirmConfirmText = "Create";
        if (this.editMode) {
            confirmConfirmText = "Confirm";
        }
        confirmMeta.itemName((Component)Component.text((String)confirmConfirmText, (TextColor)NamedTextColor.GREEN));
        confirm.setItemMeta(confirmMeta);
        Button minTeamButton = new Button(minTeamItem, player -> {}, player -> {
            if (this.minTeams - 1 < 1) {
                return;
            }
            --this.minTeams;
            this.update();
        }, player -> {
            if (this.minTeams + 1 > this.maxTeams) {
                return;
            }
            ++this.minTeams;
            this.update();
        }, player -> {}, player -> {});
        Button maxTeamButton = new Button(maxTeamItem, player -> {}, player -> {
            if (this.maxTeams - 1 < 2) {
                return;
            }
            --this.maxTeams;
            if (this.minTeams > this.maxTeams) {
                this.minTeams = this.maxTeams;
            }
            this.update();
        }, player -> {
            ++this.maxTeams;
            this.update();
        }, player -> {}, player -> {});
        Button maxArmorNormalButton = new Button(maxArmorNormalItem, player -> {}, player -> {
            if (this.maxArmorNormal - 1 < 0) {
                return;
            }
            --this.maxArmorNormal;
            this.update();
        }, player -> {
            ++this.maxArmorNormal;
            this.update();
        }, player -> {}, player -> {});
        Button maxArmorOPButton = new Button(maxArmorOPItem, player -> {}, player -> {
            if (this.maxArmorOP - 1 < 0) {
                return;
            }
            --this.maxArmorOP;
            this.update();
        }, player -> {
            ++this.maxArmorOP;
            this.update();
        }, player -> {}, player -> {});
        Button teamSizeButton = new Button(teamSizeItem, player -> {}, player -> {
            if (this.teamSize - 1 < 1) {
                return;
            }
            --this.teamSize;
            this.update();
        }, player -> {
            ++this.teamSize;
            this.update();
        }, player -> {}, player -> {});
        Button chestRefillButton = new Button(chestRefillItem, player -> {}, player -> {
            if (this.chestRefill - 1 < 1) {
                return;
            }
            --this.chestRefill;
            this.update();
        }, player -> {
            ++this.chestRefill;
            this.update();
        }, player -> {
            this.chestRefill = this.chestRefill - 5 < 1 ? 1 : (this.chestRefill -= 5);
            this.update();
        }, player -> {
            this.chestRefill += 5;
            this.update();
        });
        Button killXpButton = new Button(killXpItem, player -> {}, player -> {
            if (this.xpPerKill - 1 < 0) {
                return;
            }
            --this.xpPerKill;
            this.update();
        }, player -> {
            ++this.xpPerKill;
            this.update();
        }, player -> {
            this.xpPerKill = this.xpPerKill - 5 < 0 ? 0 : (this.xpPerKill -= 5);
            this.update();
        }, player -> {
            this.xpPerKill += 5;
            this.update();
        });
        Button winXpButton = new Button(winXpItem, player -> {}, player -> {
            if (this.xpPerWin - 1 < 0) {
                return;
            }
            --this.xpPerWin;
            this.update();
        }, player -> {
            ++this.xpPerWin;
            this.update();
        }, player -> {
            this.xpPerWin = this.xpPerWin - 5 < 0 ? 0 : (this.xpPerWin -= 5);
            this.update();
        }, player -> {
            this.xpPerWin += 5;
            this.update();
        });
        Button createButton = new Button(confirm, player -> {
            player.closeInventory();
            GameConfiguration config = new GameConfiguration(this.name, this.minTeams, this.maxTeams, this.teamSize, this.maxArmorNormal, this.maxArmorOP, this.chestRefill, this.xpPerKill, this.xpPerWin, this.mapIds);
            GameConfigurationManager.saveGameConfiguration(config);
            if (this.editMode) {
                Message.send((CommandSender)player, "<green>Successfully edited the game config: " + this.name);
            } else {
                Message.send((CommandSender)player, "<green>Successfully created the game config: " + this.name);
            }
        }, player -> {}, player -> {}, player -> {}, player -> {});
        this.setButton(10, minTeamButton);
        this.setButton(12, maxTeamButton);
        this.setButton(28, maxArmorNormalButton);
        this.setButton(14, teamSizeButton);
        this.setButton(16, killXpButton);
        this.setButton(30, maxArmorOPButton);
        this.setButton(32, chestRefillButton);
        this.setButton(34, winXpButton);
        this.setButton(49, createButton);
        this.setItem(53, configItem);
        for (ItemStack item : this.getInventory().getContents()) {
            if (item == null || !item.hasItemMeta()) continue;
            ItemMeta meta = item.getItemMeta();
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ADDITIONAL_TOOLTIP});
            item.setItemMeta(meta);
        }
    }
}

