/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skywars.menus;

import java.util.ArrayList;
import java.util.List;
import me.tomqnto.skywars.game.Game;
import me.tomqnto.skywars.game.GameManager;
import me.tomqnto.skywars.menus.api.Button;
import me.tomqnto.skywars.menus.api.PagedMenu;
import me.tomqnto.skywars.menus.api.SimpleMenu;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class GamesMenu
extends PagedMenu {
    private final GameManager gameManager;

    public GamesMenu(GameManager gameManager) {
        super(SimpleMenu.Rows.FIVE, (Component)Component.text((String)"Games"));
        this.gameManager = gameManager;
    }

    @Override
    public void onSetup() {
        List<Game> games = this.gameManager.getGames().values().stream().filter(game -> !game.hasStarted()).toList();
        ArrayList<Button> buttons = new ArrayList<Button>();
        for (Game game2 : games) {
            ItemStack item = new ItemStack(Material.ENDER_EYE);
            ItemMeta meta = item.getItemMeta();
            meta.itemName((Component)Component.text((String)"Skywars", (TextColor)NamedTextColor.GOLD));
            String playerCount = "%s/%s".formatted(game2.getPlayerCount(), game2.getMaxPlayers());
            String map = game2.getMap().getName();
            String id = game2.getId();
            ArrayList loreList = new ArrayList();
            TextComponent empty = Component.empty();
            TextComponent lore1 = Component.text((String)id, (TextColor)NamedTextColor.DARK_GRAY);
            Component lore2 = Component.text((String)"Players: ", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)playerCount, (TextColor)NamedTextColor.AQUA));
            Component lore3 = Component.text((String)"Config: ", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)game2.getGameConfiguration().getName(), (TextColor)NamedTextColor.AQUA));
            Component lore4 = Component.text((String)"Map: ", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)map, (TextColor)NamedTextColor.AQUA));
            meta.lore(List.of(lore1, empty, lore2, lore3, lore4, empty));
            meta.lore(meta.lore().stream().map(line -> line.decoration(TextDecoration.ITALIC, false)).toList());
            item.setItemMeta(meta);
            buttons.add(new Button(item, player -> player.performCommand("sw join id:%s".formatted(id)), player -> {}, player -> {}, player -> {}, player -> {}));
        }
        this.addAll(buttons);
    }
}

