/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skywars.menus;

import java.util.ArrayList;
import java.util.List;
import me.tomqnto.skywars.configs.KillMessagesConfig;
import me.tomqnto.skywars.configs.PlayerConfig;
import me.tomqnto.skywars.menus.api.Button;
import me.tomqnto.skywars.menus.api.PagedMenu;
import me.tomqnto.skywars.menus.api.SimpleMenu;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class KillMessageMenu
extends PagedMenu {
    private final Player player;

    public KillMessageMenu(Player player) {
        super(SimpleMenu.Rows.SIX, (Component)Component.text((String)"Kill Messages", (TextColor)NamedTextColor.RED));
        this.player = player;
    }

    @Override
    public void onSetup() {
        ArrayList<Button> buttons = new ArrayList<Button>();
        for (String key : KillMessagesConfig.getMessageKeys()) {
            Material material;
            String message = KillMessagesConfig.getMessage(key, this.player.getName(), this.player.getName());
            String name = KillMessagesConfig.getDisplayName(key);
            try {
                material = Material.valueOf((String)KillMessagesConfig.getMaterial(key));
            }
            catch (IllegalArgumentException e) {
                material = Material.REDSTONE;
            }
            ItemStack item = new ItemStack(material);
            ItemMeta meta = item.getItemMeta();
            meta.itemName(MiniMessage.miniMessage().deserialize((Object)name));
            Component messageComponent = MiniMessage.miniMessage().deserialize((Object)message).decoration(TextDecoration.ITALIC, false);
            PlayerConfig.getKillMessageKey(this.player);
            Component actionText = PlayerConfig.getKillMessageKey(this.player) != null && PlayerConfig.getKillMessageKey(this.player).equals(key) ? Component.text((String)"\u25b6 [Selected] \u25c0", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false) : Component.text((String)"\u00bb Click to select \u00ab", (TextColor)NamedTextColor.AQUA).decoration(TextDecoration.ITALIC, false);
            meta.lore(List.of(Component.text((String)key, (TextColor)NamedTextColor.DARK_GRAY).decoration(TextDecoration.ITALIC, false), Component.empty(), Component.text((String)"Kill Message: ", (TextColor)NamedTextColor.RED).decoration(TextDecoration.ITALIC, false), messageComponent, Component.empty(), actionText));
            item.setItemMeta(meta);
            Button button = new Button(item, player1 -> {
                PlayerConfig.setKillMessageKey(player1, key);
                this.update();
            }, player1 -> {}, player1 -> {}, player1 -> {}, player1 -> {});
            buttons.add(button);
        }
        this.addAll(buttons);
    }
}

