/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skywars.menus.api;

import java.util.HashMap;
import java.util.function.Consumer;
import me.tomqnto.skywars.SkywarsPlus;
import me.tomqnto.skywars.menus.api.Button;
import me.tomqnto.skywars.menus.api.Menu;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public abstract class SimpleMenu
implements Menu,
Listener {
    private final Inventory inventory;
    private HashMap<Integer, Consumer<Player>> actionsMap = new HashMap();
    private HashMap<Integer, Consumer<Player>> actionsRightMap = new HashMap();
    private HashMap<Integer, Consumer<Player>> actionsLeftMap = new HashMap();
    private HashMap<Integer, Consumer<Player>> actionsShiftRightMap = new HashMap();
    private HashMap<Integer, Consumer<Player>> actionsShiftLeftMap = new HashMap();
    private HashMap<Integer, ItemStack> itemsMap = new HashMap();

    public SimpleMenu(Rows rows, Component title) {
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)rows.getSize(), (Component)title);
        SkywarsPlus.getInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)SkywarsPlus.getInstance());
    }

    @Override
    public void click(Player player, int slot) {
        Consumer<Player> action = this.actionsMap.get(slot);
        if (action != null) {
            action.accept(player);
        }
    }

    @Override
    public void clickRight(Player player, int slot) {
        Consumer<Player> action = this.actionsRightMap.get(slot);
        if (action != null) {
            action.accept(player);
        }
    }

    @Override
    public void clickLeft(Player player, int slot) {
        Consumer<Player> action = this.actionsLeftMap.get(slot);
        if (action != null) {
            action.accept(player);
        }
    }

    @Override
    public void clickShiftRight(Player player, int slot) {
        Consumer<Player> action = this.actionsShiftRightMap.get(slot);
        if (action != null) {
            action.accept(player);
        }
    }

    @Override
    public void clickShiftLeft(Player player, int slot) {
        Consumer<Player> action = this.actionsShiftLeftMap.get(slot);
        if (action != null) {
            action.accept(player);
        }
    }

    @Override
    public void setButton(int slot, Button button) {
        this.setItem(slot, button.getItemStack(), button.getAction(), button.getActionRightClick(), button.getActionLeftClick(), button.getActionShiftRightClick(), button.getActionShiftLeftClick());
    }

    @Override
    public void setItem(int slot, ItemStack item) {
        this.setItem(slot, item, player -> {}, player -> {}, player -> {}, player -> {}, player -> {});
    }

    @Override
    public void setItem(int slot, ItemStack item, Consumer<Player> action, Consumer<Player> actionRight, Consumer<Player> actionLeft, Consumer<Player> actionShiftRight, Consumer<Player> actionShiftLeft) {
        this.actionsMap.put(slot, action);
        this.actionsRightMap.put(slot, actionRight);
        this.actionsLeftMap.put(slot, actionLeft);
        this.actionsShiftRightMap.put(slot, actionShiftRight);
        this.actionsShiftLeftMap.put(slot, actionShiftLeft);
        this.itemsMap.put(slot, item);
        this.getInventory().setItem(slot, item);
    }

    @Override
    public void update() {
        this.inventory.clear();
        this.itemsMap.clear();
        this.actionsMap.clear();
        this.actionsLeftMap.clear();
        this.actionsRightMap.clear();
        this.onSetup();
    }

    @Override
    public abstract void onSetup();

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    public HashMap<Integer, ItemStack> getItemsMap() {
        return this.itemsMap;
    }

    public HashMap<Integer, Consumer<Player>> getActionsMap() {
        return this.actionsMap;
    }

    public static enum Rows {
        ONE(1),
        TWO(2),
        THREE(3),
        FOUR(4),
        FIVE(5),
        SIX(6);

        private final int size;

        private Rows(int rows) {
            this.size = rows * 9;
        }

        public int getSize() {
            return this.size;
        }
    }
}

