/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skywars.tasks;

import me.tomqnto.skywars.Message;
import me.tomqnto.skywars.game.Game;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.bukkit.scheduler.BukkitRunnable;

public class ChestRefillCountdown
extends BukkitRunnable {
    private final Game game;
    private final int REFILL_TIME;
    private int secondsLeft;
    private String timeLeftFormatted;

    public ChestRefillCountdown(Game game) {
        this.game = game;
        this.secondsLeft = this.REFILL_TIME = game.getGameConfiguration().getChestRefillCooldown();
    }

    public void run() {
        this.timeLeftFormatted = DurationFormatUtils.formatDuration((long)((long)this.secondsLeft * 1000L), (String)"mm':'ss");
        if (this.game.isActive()) {
            this.game.updateScoreboardChestRefill();
            if (this.secondsLeft == 0) {
                this.game.getChestManager().resetChests();
                this.game.broadcastTitle(MiniMessage.miniMessage().deserialize((Object)Message.CHEST_REFILLED.text()), (Component)Component.empty(), null);
                this.secondsLeft = this.REFILL_TIME;
            }
            --this.secondsLeft;
        } else {
            this.cancel();
        }
    }

    public int getTimeLeftInSeconds() {
        return this.secondsLeft;
    }

    public String getTimeLeftFormatted() {
        if (this.timeLeftFormatted == null) {
            return "null";
        }
        return this.timeLeftFormatted;
    }
}

