/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skywars.tasks;

import java.time.Duration;
import me.tomqnto.skywars.Message;
import me.tomqnto.skywars.game.Game;
import me.tomqnto.skywars.game.GameState;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Sound;
import org.bukkit.scheduler.BukkitRunnable;

public class StartCountdown
extends BukkitRunnable {
    private final Game game;
    private int time = 30;
    private final MiniMessage mm = MiniMessage.miniMessage();

    public StartCountdown(Game game) {
        this.game = game;
    }

    public void run() {
        if (this.game.isStarting()) {
            this.game.updateScoreboardStartCountdown();
            this.game.getInGamePlayers().forEach(player -> player.setLevel(this.time));
            if (this.time == 30 || this.time == 20 || this.time == 15 || this.time == 10 || this.time < 6 && this.time > 0) {
                this.game.getInGamePlayers().forEach(player -> player.playSound(player.getLocation(), Sound.BLOCK_METAL_PRESSURE_PLATE_CLICK_ON, 1.0f, 1.3f));
                this.game.broadcastMessage(Message.GAME_STARTING.setPlaceholders(new TagResolver[]{Placeholder.unparsed((String)"time", (String)String.valueOf(this.time))}));
                this.game.getGamePlayers().keySet().forEach(Audience::clearTitle);
                this.game.broadcastTitle(this.mm.deserialize((Object)Message.GAME_STARTING_TITLE.setPlaceholders(new TagResolver[]{Placeholder.unparsed((String)"time", (String)String.valueOf(this.time))})), this.mm.deserialize((Object)Message.GAME_STARTING_SUBTITLE.setPlaceholders(new TagResolver[]{Placeholder.unparsed((String)"time", (String)String.valueOf(this.time))})), Duration.ofMillis(0L), Duration.ofMillis(1000L), Duration.ofMillis(0L), null);
            }
            if (this.time <= 0) {
                this.game.setGameState(GameState.STARTED);
                this.game.getGamePlayers().keySet().forEach(Audience::clearTitle);
                this.game.getInGamePlayers().forEach(player -> player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BELL, 1.0f, 1.3f));
                this.game.broadcastTitle(this.mm.deserialize((Object)Message.GAME_STARTED_TITLE.text()), this.mm.deserialize((Object)Message.GAME_STARTED_SUBTITLE.text()), null);
                this.game.broadcastMessage(Message.GAME_STARTED.text());
                this.cancel();
                return;
            }
            --this.time;
        }
    }

    public void setTime(int time) {
        this.time = time;
    }

    public int getTime() {
        return this.time;
    }
}

