/*
 * Decompiled with CFR 0.152.
 */
package net.trique.abyssborne.block;

import java.util.function.Supplier;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.trique.abyssborne.block.AbyssNyliumBlock;
import net.trique.abyssborne.block.AbyssPortalBlock;
import net.trique.abyssborne.block.AbyssRootsBlock;
import net.trique.abyssborne.block.AbysstoneBlock;
import net.trique.abyssborne.item.AbyssItems;
import net.trique.abyssborne.material.AbyssFluids;

public class AbyssBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"abyssborne");
    public static final DeferredBlock<Block> ABYSSTONE = AbyssBlocks.registerBlock("abysstone", () -> new AbysstoneBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLUE).instrument(NoteBlockInstrument.BASEDRUM).strength(3.0f).requiresCorrectToolForDrops().sound(SoundType.NETHERRACK)));
    public static final DeferredBlock<Block> ABYSS_AMARYLLIUM_ORE = AbyssBlocks.registerBlock("abyss_amaryllium_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)2, (int)4), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLUE).instrument(NoteBlockInstrument.BASEDRUM).strength(3.0f, 3.0f).requiresCorrectToolForDrops().sound(SoundType.NETHER_GOLD_ORE)));
    public static final DeferredBlock<Block> AMARYLLIUM_BLOCK = AbyssBlocks.registerBlock("amaryllium_block", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).instrument(NoteBlockInstrument.IRON_XYLOPHONE).strength(5.0f, 6.0f).requiresCorrectToolForDrops().sound(SoundType.METAL)));
    public static final DeferredBlock<Block> ABYSS_CRIMSONITE_ORE = AbyssBlocks.registerBlock("abyss_crimsonite_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)2, (int)4), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLUE).instrument(NoteBlockInstrument.BASEDRUM).strength(3.0f, 3.0f).requiresCorrectToolForDrops().sound(SoundType.NETHER_GOLD_ORE)));
    public static final DeferredBlock<Block> CRIMSONITE_BLOCK = AbyssBlocks.registerBlock("crimsonite_block", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PINK).instrument(NoteBlockInstrument.IRON_XYLOPHONE).strength(5.0f, 6.0f).requiresCorrectToolForDrops().sound(SoundType.METAL)));
    public static final DeferredBlock<Block> AZURE_NYLIUM = AbyssBlocks.registerBlock("azure_nylium", () -> new AbyssNyliumBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_BLUE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(0.4f).sound(SoundType.NYLIUM).randomTicks()));
    public static final DeferredBlock<Block> NIGHT_NYLIUM = AbyssBlocks.registerBlock("night_nylium", () -> new AbyssNyliumBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(0.4f).sound(SoundType.NYLIUM).randomTicks()));
    public static final DeferredBlock<Block> AMBER_NYLIUM = AbyssBlocks.registerBlock("amber_nylium", () -> new AbyssNyliumBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(0.4f).sound(SoundType.NYLIUM).randomTicks()));
    public static final DeferredBlock<Block> ABYSS_PORTAL = AbyssBlocks.registerBlock("abyss_portal", () -> new AbyssPortalBlock(BlockBehaviour.Properties.of().noCollission().noOcclusion().strength(-1.0f).lightLevel(state -> 12).pushReaction(PushReaction.BLOCK).noLootTable()));
    public static final DeferredBlock<LiquidBlock> PURPLE_LAVA = BLOCKS.register("purple_lava", () -> new LiquidBlock(AbyssFluids.PURPLE_LAVA, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).replaceable().noCollission().randomTicks().strength(100.0f).pushReaction(PushReaction.DESTROY).noLootTable().liquid().lightLevel(state -> 12).sound(SoundType.EMPTY)));
    public static final DeferredBlock<Block> NIGHT_ROOTS = AbyssBlocks.registerBlock("night_roots", () -> new AbyssRootsBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLUE).replaceable().noCollission().instabreak().sound(SoundType.ROOTS).offsetType(BlockBehaviour.OffsetType.XZ).lightLevel(state -> 5).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> AZURE_ROOTS = AbyssBlocks.registerBlock("azure_roots", () -> new AbyssRootsBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLUE).replaceable().noCollission().instabreak().sound(SoundType.ROOTS).offsetType(BlockBehaviour.OffsetType.XZ).lightLevel(state -> 5).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> AMBER_ROOTS = AbyssBlocks.registerBlock("amber_roots", () -> new AbyssRootsBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLUE).replaceable().noCollission().instabreak().sound(SoundType.ROOTS).offsetType(BlockBehaviour.OffsetType.XZ).lightLevel(state -> 5).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> NIGHT_FUNGUS = AbyssBlocks.registerBlock("night_fungus", () -> new AbyssRootsBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLUE).replaceable().noCollission().instabreak().sound(SoundType.FUNGUS).offsetType(BlockBehaviour.OffsetType.XZ).lightLevel(state -> 5).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> AZURE_FUNGUS = AbyssBlocks.registerBlock("azure_fungus", () -> new AbyssRootsBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLUE).replaceable().noCollission().instabreak().sound(SoundType.FUNGUS).offsetType(BlockBehaviour.OffsetType.XZ).lightLevel(state -> 5).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> AMBER_FUNGUS = AbyssBlocks.registerBlock("amber_fungus", () -> new AbyssRootsBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLUE).replaceable().noCollission().instabreak().sound(SoundType.FUNGUS).offsetType(BlockBehaviour.OffsetType.XZ).lightLevel(state -> 5).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> NIGHT_BUSH = AbyssBlocks.registerBlock("night_bush", () -> new AbyssRootsBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLUE).replaceable().noCollission().instabreak().sound(SoundType.ROOTS).offsetType(BlockBehaviour.OffsetType.XZ).lightLevel(state -> 5).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> AZURE_BUSH = AbyssBlocks.registerBlock("azure_bush", () -> new AbyssRootsBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLUE).replaceable().noCollission().instabreak().sound(SoundType.ROOTS).offsetType(BlockBehaviour.OffsetType.XZ).lightLevel(state -> 5).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> AMBER_BUSH = AbyssBlocks.registerBlock("amber_bush", () -> new AbyssRootsBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLUE).replaceable().noCollission().instabreak().sound(SoundType.ROOTS).offsetType(BlockBehaviour.OffsetType.XZ).lightLevel(state -> 5).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> STRANGE_CLUSTER = AbyssBlocks.registerBlock("strange_cluster", () -> new AmethystClusterBlock(7.0f, 3.0f, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).forceSolidOn().noOcclusion().sound(SoundType.AMETHYST_CLUSTER).strength(1.5f).lightLevel(state -> 12).pushReaction(PushReaction.DESTROY).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> WEIRD_CLUSTER = AbyssBlocks.registerBlock("weird_cluster", () -> new AmethystClusterBlock(7.0f, 3.0f, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).forceSolidOn().noOcclusion().sound(SoundType.AMETHYST_CLUSTER).strength(1.5f).lightLevel(state -> 12).pushReaction(PushReaction.DESTROY).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> ODD_CLUSTER = AbyssBlocks.registerBlock("odd_cluster", () -> new AmethystClusterBlock(7.0f, 3.0f, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).forceSolidOn().noOcclusion().sound(SoundType.AMETHYST_CLUSTER).strength(1.5f).lightLevel(state -> 12).pushReaction(PushReaction.DESTROY).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> AZURE_NYLIUM_MASS = AbyssBlocks.registerBlock("azure_nylium_mass", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_BLUE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(0.4f).sound(SoundType.NYLIUM).lightLevel(state -> 12).randomTicks()));
    public static final DeferredBlock<Block> NIGHT_NYLIUM_MASS = AbyssBlocks.registerBlock("night_nylium_mass", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(0.4f).sound(SoundType.NYLIUM).lightLevel(state -> 12).randomTicks()));
    public static final DeferredBlock<Block> AMBER_NYLIUM_MASS = AbyssBlocks.registerBlock("amber_nylium_mass", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(0.4f).sound(SoundType.NYLIUM).lightLevel(state -> 12).randomTicks()));

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        AbyssBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        AbyssItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

