/*
 * Decompiled with CFR 0.152.
 */
package net.trique.abyssborne.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LightEngine;
import net.trique.abyssborne.block.AbyssBlocks;

public class AbyssNyliumBlock
extends Block
implements BonemealableBlock {
    public static final MapCodec<AbyssNyliumBlock> CODEC = AbyssNyliumBlock.simpleCodec(AbyssNyliumBlock::new);

    public AbyssNyliumBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public MapCodec<AbyssNyliumBlock> codec() {
        return CODEC;
    }

    private static boolean canRemainNylium(BlockState state, LevelReader reader, BlockPos pos) {
        BlockPos above = pos.above();
        BlockState aboveState = reader.getBlockState(above);
        int lightBlock = LightEngine.getLightBlockInto((BlockGetter)reader, (BlockState)state, (BlockPos)pos, (BlockState)aboveState, (BlockPos)above, (Direction)Direction.UP, (int)aboveState.getLightBlock((BlockGetter)reader, above));
        return lightBlock < reader.getMaxLightLevel();
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!AbyssNyliumBlock.canRemainNylium(state, (LevelReader)level, pos)) {
            level.setBlockAndUpdate(pos, ((Block)AbyssBlocks.ABYSSTONE.get()).defaultBlockState());
        }
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return level.getBlockState(pos.above()).isAir();
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
    }

    public BonemealableBlock.Type getType() {
        return BonemealableBlock.Type.NEIGHBOR_SPREADER;
    }
}

