/*
 * Decompiled with CFR 0.152.
 */
package net.trique.abyssborne.block;

import net.kyrptonaught.customportalapi.CustomPortalBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbyssPortalBlock
extends CustomPortalBlock {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.AXIS;
    protected static final VoxelShape X_SHAPE = Block.box((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape Z_SHAPE = Block.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    protected static final VoxelShape Y_SHAPE = Block.box((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);

    public AbyssPortalBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(AXIS, (Comparable)Direction.Axis.X));
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return switch ((Direction.Axis)state.getValue(AXIS)) {
            case Direction.Axis.Z -> Z_SHAPE;
            case Direction.Axis.Y -> Y_SHAPE;
            default -> X_SHAPE;
        };
    }

    @NotNull
    public ItemStack getCloneItemStack(@NotNull LevelReader world, @NotNull BlockPos pos, @NotNull BlockState state) {
        return ItemStack.EMPTY;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS});
    }

    public void animateTick(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, RandomSource random) {
        if (random.nextInt(100) == 0) {
            level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.PORTAL_AMBIENT, SoundSource.BLOCKS, 0.5f, random.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double d = (double)pos.getX() + random.nextDouble();
            double e = (double)pos.getY() + random.nextDouble();
            double f = (double)pos.getZ() + random.nextDouble();
            double g = (random.nextFloat() - 0.5f) * 0.5f;
            double h = (random.nextFloat() - 0.5f) * 0.5f;
            double j = (random.nextFloat() - 0.5f) * 0.5f;
            int k = random.nextInt(2) * 2 - 1;
            if (!level.getBlockState(pos.west()).is((Block)this) && !level.getBlockState(pos.east()).is((Block)this)) {
                d = (double)pos.getX() + 0.5 + 0.25 * (double)k;
                g = random.nextFloat() * 2.0f * (float)k;
                continue;
            }
            f = (double)pos.getZ() + 0.5 + 0.25 * (double)k;
            j = random.nextFloat() * 2.0f * (float)k;
        }
    }

    public void entityInside(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Entity entity) {
        if (entity.canUsePortal(false)) {
            entity.setAsInsidePortal((Portal)this, pos);
        }
    }

    public int getPortalTransitionTime(@NotNull ServerLevel world, @NotNull Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return Math.max(1, world.getGameRules().getInt(player.getAbilities().invulnerable ? GameRules.RULE_PLAYERS_NETHER_PORTAL_CREATIVE_DELAY : GameRules.RULE_PLAYERS_NETHER_PORTAL_DEFAULT_DELAY));
        }
        return 0;
    }

    @Nullable
    public DimensionTransition getPortalDestination(@NotNull ServerLevel world, @NotNull Entity entity, @NotNull BlockPos pos) {
        return super.getPortalDestination(world, entity, pos);
    }

    @NotNull
    public Portal.Transition getLocalTransition() {
        return Portal.Transition.CONFUSION;
    }
}

