/*
 * Decompiled with CFR 0.152.
 */
package net.trique.abyssborne.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.trique.abyssborne.block.AbyssBlocks;

public class AbysstoneBlock
extends Block
implements BonemealableBlock {
    public static final MapCodec<AbysstoneBlock> CODEC = AbysstoneBlock.simpleCodec(AbysstoneBlock::new);

    public AbysstoneBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public MapCodec<AbysstoneBlock> codec() {
        return CODEC;
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        if (!level.getBlockState(pos.above()).propagatesSkylightDown((BlockGetter)level, pos)) {
            return false;
        }
        for (BlockPos checkPos : BlockPos.betweenClosed((BlockPos)pos.offset(-1, -1, -1), (BlockPos)pos.offset(1, 1, 1))) {
            BlockState neighborState = level.getBlockState(checkPos);
            if (!neighborState.is((Block)AbyssBlocks.AMBER_NYLIUM.get()) && !neighborState.is((Block)AbyssBlocks.AZURE_NYLIUM.get()) && !neighborState.is((Block)AbyssBlocks.NIGHT_NYLIUM.get())) continue;
            return true;
        }
        return false;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        boolean hasAmber = false;
        boolean hasAzure = false;
        boolean hasNight = false;
        for (BlockPos checkPos : BlockPos.betweenClosed((BlockPos)pos.offset(-1, -1, -1), (BlockPos)pos.offset(1, 1, 1))) {
            BlockState neighborState = level.getBlockState(checkPos);
            if (neighborState.is((Block)AbyssBlocks.AMBER_NYLIUM.get())) {
                hasAmber = true;
            }
            if (neighborState.is((Block)AbyssBlocks.AZURE_NYLIUM.get())) {
                hasAzure = true;
            }
            if (neighborState.is((Block)AbyssBlocks.NIGHT_NYLIUM.get())) {
                hasNight = true;
            }
            if (!(hasAmber && hasAzure || hasAmber && hasNight) && (!hasAzure || !hasNight)) continue;
            break;
        }
        if (hasAmber && hasAzure || hasAmber && hasNight || hasAzure && hasNight) {
            int choice = random.nextInt(3);
            if (choice == 0) {
                level.setBlock(pos, ((Block)AbyssBlocks.AMBER_NYLIUM.get()).defaultBlockState(), 3);
            } else if (choice == 1) {
                level.setBlock(pos, ((Block)AbyssBlocks.AZURE_NYLIUM.get()).defaultBlockState(), 3);
            } else {
                level.setBlock(pos, ((Block)AbyssBlocks.NIGHT_NYLIUM.get()).defaultBlockState(), 3);
            }
        } else if (hasAmber) {
            level.setBlock(pos, ((Block)AbyssBlocks.AMBER_NYLIUM.get()).defaultBlockState(), 3);
        } else if (hasAzure) {
            level.setBlock(pos, ((Block)AbyssBlocks.AZURE_NYLIUM.get()).defaultBlockState(), 3);
        } else if (hasNight) {
            level.setBlock(pos, ((Block)AbyssBlocks.NIGHT_NYLIUM.get()).defaultBlockState(), 3);
        }
    }

    public BonemealableBlock.Type getType() {
        return BonemealableBlock.Type.NEIGHBOR_SPREADER;
    }
}

