/*
 * Decompiled with CFR 0.152.
 */
package net.trique.abyssborne.datagen;

import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.trique.abyssborne.block.AbyssBlocks;
import net.trique.abyssborne.item.AbyssItems;

public class AbyssBlockLootTableProvider
extends BlockLootSubProvider {
    public AbyssBlockLootTableProvider(HolderLookup.Provider registries) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), registries);
    }

    protected void generate() {
        this.dropSelf((Block)AbyssBlocks.ABYSSTONE.get());
        this.dropSelf((Block)AbyssBlocks.AMARYLLIUM_BLOCK.get());
        this.dropSelf((Block)AbyssBlocks.CRIMSONITE_BLOCK.get());
        this.dropSelf((Block)AbyssBlocks.AZURE_NYLIUM_MASS.get());
        this.dropSelf((Block)AbyssBlocks.NIGHT_NYLIUM_MASS.get());
        this.dropSelf((Block)AbyssBlocks.AMBER_NYLIUM_MASS.get());
        this.add((Block)AbyssBlocks.AZURE_NYLIUM.get(), block -> this.createSilkTouchDispatchTable((Block)block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)AbyssBlocks.ABYSSTONE.get())))));
        this.add((Block)AbyssBlocks.NIGHT_NYLIUM.get(), block -> this.createSilkTouchDispatchTable((Block)block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)AbyssBlocks.ABYSSTONE.get())))));
        this.add((Block)AbyssBlocks.AMBER_NYLIUM.get(), block -> this.createSilkTouchDispatchTable((Block)block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)AbyssBlocks.ABYSSTONE.get())))));
        this.add((Block)AbyssBlocks.ABYSS_AMARYLLIUM_ORE.get(), b -> this.createOreDrop((Block)AbyssBlocks.ABYSS_AMARYLLIUM_ORE.get(), (Item)AbyssItems.RAW_AMARYLLIUM.get()));
        this.add((Block)AbyssBlocks.ABYSS_CRIMSONITE_ORE.get(), b -> this.createOreDrop((Block)AbyssBlocks.ABYSS_CRIMSONITE_ORE.get(), (Item)AbyssItems.RAW_CRIMSONITE.get()));
        if (AbyssBlocks.NIGHT_ROOTS != null) {
            this.dropSelf((Block)AbyssBlocks.NIGHT_ROOTS.get());
        }
        if (AbyssBlocks.AZURE_ROOTS != null) {
            this.dropSelf((Block)AbyssBlocks.AZURE_ROOTS.get());
        }
        if (AbyssBlocks.AMBER_ROOTS != null) {
            this.dropSelf((Block)AbyssBlocks.AMBER_ROOTS.get());
        }
        if (AbyssBlocks.NIGHT_FUNGUS != null) {
            this.dropSelf((Block)AbyssBlocks.NIGHT_FUNGUS.get());
        }
        if (AbyssBlocks.AZURE_FUNGUS != null) {
            this.dropSelf((Block)AbyssBlocks.AZURE_FUNGUS.get());
        }
        if (AbyssBlocks.AMBER_FUNGUS != null) {
            this.dropSelf((Block)AbyssBlocks.AMBER_FUNGUS.get());
        }
        if (AbyssBlocks.NIGHT_BUSH != null) {
            this.dropSelf((Block)AbyssBlocks.NIGHT_BUSH.get());
        }
        if (AbyssBlocks.AZURE_BUSH != null) {
            this.dropSelf((Block)AbyssBlocks.AZURE_BUSH.get());
        }
        if (AbyssBlocks.AMBER_BUSH != null) {
            this.dropSelf((Block)AbyssBlocks.AMBER_BUSH.get());
        }
        Holder.Reference fortune = this.registries.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.FORTUNE);
        this.addClusterLoot((Block)AbyssBlocks.STRANGE_CLUSTER.get(), (ItemLike)AbyssItems.STRANGE_SHARD.get(), (Holder<Enchantment>)fortune);
        this.addClusterLoot((Block)AbyssBlocks.WEIRD_CLUSTER.get(), (ItemLike)AbyssItems.WEIRD_SHARD.get(), (Holder<Enchantment>)fortune);
        this.addClusterLoot((Block)AbyssBlocks.ODD_CLUSTER.get(), (ItemLike)AbyssItems.ODD_SHARD.get(), (Holder<Enchantment>)fortune);
    }

    private void addClusterLoot(Block cluster, ItemLike shard, Holder<Enchantment> fortune) {
        this.add(cluster, b -> this.createSilkTouchDispatchTable((Block)b, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)b, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)shard).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)fortune)))));
    }

    protected Iterable<Block> getKnownBlocks() {
        return AbyssBlocks.BLOCKS.getEntries().stream().map(Holder::value)::iterator;
    }
}

