/*
 * Decompiled with CFR 0.152.
 */
package net.trique.abyssborne.datagen;

import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.trique.abyssborne.block.AbyssBlocks;

public class AbyssBlockStateProvider
extends BlockStateProvider {
    public AbyssBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "abyssborne", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.blockWithItem(AbyssBlocks.ABYSSTONE);
        this.blockWithItem(AbyssBlocks.ABYSS_AMARYLLIUM_ORE);
        this.blockWithItem(AbyssBlocks.AMARYLLIUM_BLOCK);
        this.blockWithItem(AbyssBlocks.ABYSS_CRIMSONITE_ORE);
        this.blockWithItem(AbyssBlocks.CRIMSONITE_BLOCK);
        this.massBlockWithItem(AbyssBlocks.AZURE_NYLIUM_MASS);
        this.massBlockWithItem(AbyssBlocks.NIGHT_NYLIUM_MASS);
        this.massBlockWithItem(AbyssBlocks.AMBER_NYLIUM_MASS);
        this.nyliumBlockWithItem(AbyssBlocks.AZURE_NYLIUM, "abysstone");
        this.nyliumBlockWithItem(AbyssBlocks.NIGHT_NYLIUM, "abysstone");
        this.nyliumBlockWithItem(AbyssBlocks.AMBER_NYLIUM, "abysstone");
        this.crossBlockWithItem2D(AbyssBlocks.NIGHT_ROOTS);
        this.crossBlockWithItem2D(AbyssBlocks.AZURE_ROOTS);
        this.crossBlockWithItem2D(AbyssBlocks.AMBER_ROOTS);
        this.crossBlockWithItem2D(AbyssBlocks.NIGHT_FUNGUS);
        this.crossBlockWithItem2D(AbyssBlocks.AZURE_FUNGUS);
        this.crossBlockWithItem2D(AbyssBlocks.AMBER_FUNGUS);
        this.crossBlockWithItem2D(AbyssBlocks.NIGHT_BUSH);
        this.crossBlockWithItem2D(AbyssBlocks.AZURE_BUSH);
        this.crossBlockWithItem2D(AbyssBlocks.AMBER_BUSH);
        this.clusterBlockWithItem(AbyssBlocks.STRANGE_CLUSTER);
        this.clusterBlockWithItem(AbyssBlocks.WEIRD_CLUSTER);
        this.clusterBlockWithItem(AbyssBlocks.ODD_CLUSTER);
    }

    private void blockWithItem(DeferredBlock<?> deferredBlock) {
        this.simpleBlockWithItem((Block)deferredBlock.get(), this.cubeAll((Block)deferredBlock.get()));
    }

    private void nyliumBlockWithItem(DeferredBlock<?> block, String baseBlockTextureName) {
        String name = block.getId().getPath();
        this.models().cubeBottomTop(name, this.modLoc("block/" + name + "_side"), this.modLoc("block/" + baseBlockTextureName), this.modLoc("block/" + name));
        this.simpleBlockWithItem((Block)block.get(), (ModelFile)this.models().getExistingFile(this.modLoc(name)));
    }

    private void crossBlockWithItem2D(DeferredBlock<?> block) {
        String name = block.getId().getPath();
        this.simpleBlock((Block)block.get(), (ModelFile)((BlockModelBuilder)this.models().cross(name, this.modLoc("block/" + name))).renderType("cutout"));
        ((ItemModelBuilder)this.itemModels().withExistingParent(name, this.mcLoc("item/generated"))).texture("layer0", this.modLoc("block/" + name));
    }

    private void clusterBlockWithItem(DeferredBlock<?> block) {
        String name = block.getId().getPath();
        BlockModelBuilder blockModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.mcLoc("block/cross"))).texture("cross", this.modLoc("block/" + name))).renderType("cutout");
        this.getVariantBuilder((Block)block.get()).forAllStatesExcept(state -> {
            Direction facing = (Direction)state.getValue((Property)BlockStateProperties.FACING);
            int xRot = 0;
            int yRot = 0;
            switch (facing) {
                case UP: {
                    xRot = 0;
                    yRot = 0;
                    break;
                }
                case DOWN: {
                    xRot = 180;
                    yRot = 0;
                    break;
                }
                case NORTH: {
                    xRot = 90;
                    yRot = 0;
                    break;
                }
                case SOUTH: {
                    xRot = 90;
                    yRot = 180;
                    break;
                }
                case WEST: {
                    xRot = 90;
                    yRot = 270;
                    break;
                }
                case EAST: {
                    xRot = 90;
                    yRot = 90;
                }
            }
            return ConfiguredModel.builder().modelFile((ModelFile)blockModel).rotationX(xRot).rotationY(yRot).build();
        }, new Property[]{BlockStateProperties.WATERLOGGED});
    }

    private void massBlockWithItem(DeferredBlock<?> block) {
        String name = block.getId().getPath();
        String nyliumTex = name.replace("_nylium_mass", "_nylium");
        this.simpleBlockWithItem((Block)block.get(), (ModelFile)this.models().cubeAll(name, this.modLoc("block/" + nyliumTex)));
    }
}

