/*
 * Decompiled with CFR 0.152.
 */
package net.trique.abyssborne.datagen;

import java.util.LinkedHashMap;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import net.trique.abyssborne.block.AbyssBlocks;
import net.trique.abyssborne.item.AbyssItems;

public class AbyssItemModelProvider
extends ItemModelProvider {
    private static final LinkedHashMap<ResourceKey<TrimMaterial>, Float> trimMaterials = new LinkedHashMap();

    public AbyssItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "abyssborne", existingFileHelper);
    }

    protected void registerModels() {
        this.basicItem((Item)AbyssItems.RAW_AMARYLLIUM.get());
        this.basicItem((Item)AbyssItems.AMARYLLIUM_INGOT.get());
        this.basicItem((Item)AbyssItems.RAW_CRIMSONITE.get());
        this.basicItem((Item)AbyssItems.CRIMSONITE_INGOT.get());
        this.basicItem((Item)AbyssItems.PURPLE_LAVA_BUCKET.get());
        this.basicItem((Item)AbyssItems.STRANGE_SHARD.get());
        this.basicItem((Item)AbyssItems.WEIRD_SHARD.get());
        this.basicItem((Item)AbyssItems.ODD_SHARD.get());
        this.flatBlockItem(AbyssBlocks.NIGHT_ROOTS);
        this.flatBlockItem(AbyssBlocks.AZURE_ROOTS);
        this.flatBlockItem(AbyssBlocks.AMBER_ROOTS);
        this.flatBlockItem(AbyssBlocks.NIGHT_FUNGUS);
        this.flatBlockItem(AbyssBlocks.AZURE_FUNGUS);
        this.flatBlockItem(AbyssBlocks.AMBER_FUNGUS);
        this.flatBlockItem(AbyssBlocks.NIGHT_BUSH);
        this.flatBlockItem(AbyssBlocks.AZURE_BUSH);
        this.flatBlockItem(AbyssBlocks.AMBER_BUSH);
        this.flatBlockItem(AbyssBlocks.STRANGE_CLUSTER);
        this.flatBlockItem(AbyssBlocks.WEIRD_CLUSTER);
        this.flatBlockItem(AbyssBlocks.ODD_CLUSTER);
        this.basicItem((Item)AbyssItems.CRIMSONITE_INGOT.get());
        this.basicItem((Item)AbyssItems.RAW_CRIMSONITE.get());
        this.handheldItem(AbyssItems.CRIMSONITE_SWORD);
        this.handheldItem(AbyssItems.CRIMSONITE_PICKAXE);
        this.handheldItem(AbyssItems.CRIMSONITE_AXE);
        this.handheldItem(AbyssItems.CRIMSONITE_SHOVEL);
        this.handheldItem(AbyssItems.CRIMSONITE_HOE);
        this.trimmedArmorItem(AbyssItems.CRIMSONITE_HELMET);
        this.trimmedArmorItem(AbyssItems.CRIMSONITE_CHESTPLATE);
        this.trimmedArmorItem(AbyssItems.CRIMSONITE_LEGGINGS);
        this.trimmedArmorItem(AbyssItems.CRIMSONITE_BOOTS);
        this.basicItem((Item)AbyssItems.AMARYLLIUM_INGOT.get());
        this.basicItem((Item)AbyssItems.RAW_AMARYLLIUM.get());
        this.handheldItem(AbyssItems.AMARYLLIUM_SWORD);
        this.handheldItem(AbyssItems.AMARYLLIUM_PICKAXE);
        this.handheldItem(AbyssItems.AMARYLLIUM_AXE);
        this.handheldItem(AbyssItems.AMARYLLIUM_SHOVEL);
        this.handheldItem(AbyssItems.AMARYLLIUM_HOE);
        this.trimmedArmorItem(AbyssItems.AMARYLLIUM_HELMET);
        this.trimmedArmorItem(AbyssItems.AMARYLLIUM_CHESTPLATE);
        this.trimmedArmorItem(AbyssItems.AMARYLLIUM_LEGGINGS);
        this.trimmedArmorItem(AbyssItems.AMARYLLIUM_BOOTS);
    }

    private ItemModelBuilder handheldItem(DeferredItem<?> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.parse((String)"item/handheld"))).texture("layer0", this.modLoc("item/" + item.getId().getPath()));
    }

    private void flatBlockItem(DeferredBlock<?> block) {
        String name = block.getId().getPath();
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)this.getExistingFile(this.mcLoc("item/generated")))).texture("layer0", this.modLoc("block/" + name));
    }

    private void trimmedArmorItem(DeferredItem<ArmorItem> itemDeferredItem) {
        String MOD_ID = "abyssborne";
        Object object = itemDeferredItem.get();
        if (object instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)object;
            trimMaterials.forEach((trimMaterial, value) -> {
                float trimValue = value.floatValue();
                String armorType = switch (armorItem.getEquipmentSlot()) {
                    case EquipmentSlot.HEAD -> "helmet";
                    case EquipmentSlot.CHEST -> "chestplate";
                    case EquipmentSlot.LEGS -> "leggings";
                    case EquipmentSlot.FEET -> "boots";
                    default -> "";
                };
                String armorItemPath = armorItem.toString();
                String trimPath = "trims/items/" + armorType + "_trim_" + trimMaterial.location().getPath();
                String currentTrimName = armorItemPath + "_" + trimMaterial.location().getPath() + "_trim";
                ResourceLocation armorItemResLoc = ResourceLocation.parse((String)armorItemPath);
                ResourceLocation trimResLoc = ResourceLocation.parse((String)trimPath);
                ResourceLocation trimNameResLoc = ResourceLocation.parse((String)currentTrimName);
                this.existingFileHelper.trackGenerated(trimResLoc, PackType.CLIENT_RESOURCES, ".png", "textures");
                ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(currentTrimName)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", armorItemResLoc.getNamespace() + ":item/" + armorItemResLoc.getPath())).texture("layer1", trimResLoc);
                ((ItemModelBuilder)this.withExistingParent(itemDeferredItem.getId().getPath(), this.mcLoc("item/generated"))).override().model((ModelFile)new ModelFile.UncheckedModelFile(trimNameResLoc.getNamespace() + ":item/" + trimNameResLoc.getPath())).predicate(this.mcLoc("trim_type"), trimValue).end().texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"abyssborne", (String)("item/" + itemDeferredItem.getId().getPath())));
            });
        }
    }

    static {
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.QUARTZ, Float.valueOf(0.1f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.IRON, Float.valueOf(0.2f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.NETHERITE, Float.valueOf(0.3f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.REDSTONE, Float.valueOf(0.4f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.COPPER, Float.valueOf(0.5f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.GOLD, Float.valueOf(0.6f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.EMERALD, Float.valueOf(0.7f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.DIAMOND, Float.valueOf(0.8f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.LAPIS, Float.valueOf(0.9f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.AMETHYST, Float.valueOf(1.0f));
    }
}

