/*
 * Decompiled with CFR 0.152.
 */
package net.trique.abyssborne.datagen;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.trique.abyssborne.block.AbyssBlocks;
import net.trique.abyssborne.item.AbyssItems;

public class AbyssRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public AbyssRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        List<DeferredBlock<Block>> AMARYLLIUM_SMELTABLES = List.of(AbyssItems.RAW_AMARYLLIUM, AbyssBlocks.ABYSS_AMARYLLIUM_ORE);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)AbyssBlocks.AMARYLLIUM_BLOCK.get())).pattern("BBB").pattern("BBB").pattern("BBB").define(Character.valueOf('B'), (ItemLike)AbyssItems.AMARYLLIUM_INGOT.get()).unlockedBy("has_amaryllium_ingot", AbyssRecipeProvider.has(AbyssItems.AMARYLLIUM_INGOT)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)AbyssItems.AMARYLLIUM_INGOT.get()), (int)9).requires(AbyssBlocks.AMARYLLIUM_BLOCK).unlockedBy("has_amaryllium_block", AbyssRecipeProvider.has(AbyssBlocks.AMARYLLIUM_BLOCK)).save(recipeOutput);
        AbyssRecipeProvider.oreSmelting(recipeOutput, AMARYLLIUM_SMELTABLES, RecipeCategory.MISC, (ItemLike)AbyssItems.AMARYLLIUM_INGOT.get(), 0.25f, 200, "amaryllium");
        AbyssRecipeProvider.oreBlasting(recipeOutput, AMARYLLIUM_SMELTABLES, RecipeCategory.MISC, (ItemLike)AbyssItems.AMARYLLIUM_INGOT.get(), 0.25f, 100, "amaryllium");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)AbyssItems.AMARYLLIUM_SWORD.get())).pattern(" I ").pattern(" I ").pattern(" S ").define(Character.valueOf('I'), (ItemLike)AbyssItems.AMARYLLIUM_INGOT.get()).define(Character.valueOf('S'), (ItemLike)Items.STICK).unlockedBy("has_amaryllium_ingot", AbyssRecipeProvider.has(AbyssItems.AMARYLLIUM_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)AbyssItems.AMARYLLIUM_PICKAXE.get())).pattern("III").pattern(" S ").pattern(" S ").define(Character.valueOf('I'), (ItemLike)AbyssItems.AMARYLLIUM_INGOT.get()).define(Character.valueOf('S'), (ItemLike)Items.STICK).unlockedBy("has_amaryllium_ingot", AbyssRecipeProvider.has(AbyssItems.AMARYLLIUM_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)AbyssItems.AMARYLLIUM_AXE.get())).pattern("II ").pattern("IS ").pattern(" S ").define(Character.valueOf('I'), (ItemLike)AbyssItems.AMARYLLIUM_INGOT.get()).define(Character.valueOf('S'), (ItemLike)Items.STICK).unlockedBy("has_amaryllium_ingot", AbyssRecipeProvider.has(AbyssItems.AMARYLLIUM_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)AbyssItems.AMARYLLIUM_SHOVEL.get())).pattern(" I ").pattern(" S ").pattern(" S ").define(Character.valueOf('I'), (ItemLike)AbyssItems.AMARYLLIUM_INGOT.get()).define(Character.valueOf('S'), (ItemLike)Items.STICK).unlockedBy("has_amaryllium_ingot", AbyssRecipeProvider.has(AbyssItems.AMARYLLIUM_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)AbyssItems.AMARYLLIUM_HOE.get())).pattern("II ").pattern(" S ").pattern(" S ").define(Character.valueOf('I'), (ItemLike)AbyssItems.AMARYLLIUM_INGOT.get()).define(Character.valueOf('S'), (ItemLike)Items.STICK).unlockedBy("has_amaryllium_ingot", AbyssRecipeProvider.has(AbyssItems.AMARYLLIUM_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)AbyssItems.AMARYLLIUM_HELMET.get())).pattern("III").pattern("I I").define(Character.valueOf('I'), (ItemLike)AbyssItems.AMARYLLIUM_INGOT.get()).unlockedBy("has_amaryllium_ingot", AbyssRecipeProvider.has(AbyssItems.AMARYLLIUM_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)AbyssItems.AMARYLLIUM_CHESTPLATE.get())).pattern("I I").pattern("III").pattern("III").define(Character.valueOf('I'), (ItemLike)AbyssItems.AMARYLLIUM_INGOT.get()).unlockedBy("has_amaryllium_ingot", AbyssRecipeProvider.has(AbyssItems.AMARYLLIUM_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)AbyssItems.AMARYLLIUM_LEGGINGS.get())).pattern("III").pattern("I I").pattern("I I").define(Character.valueOf('I'), (ItemLike)AbyssItems.AMARYLLIUM_INGOT.get()).unlockedBy("has_amaryllium_ingot", AbyssRecipeProvider.has(AbyssItems.AMARYLLIUM_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)AbyssItems.AMARYLLIUM_BOOTS.get())).pattern("I I").pattern("I I").define(Character.valueOf('I'), (ItemLike)AbyssItems.AMARYLLIUM_INGOT.get()).unlockedBy("has_amaryllium_ingot", AbyssRecipeProvider.has(AbyssItems.AMARYLLIUM_INGOT)).save(recipeOutput);
        List<DeferredBlock<Block>> CRIMSONITE_SMELTABLES = List.of(AbyssItems.RAW_CRIMSONITE, AbyssBlocks.ABYSS_CRIMSONITE_ORE);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)AbyssBlocks.CRIMSONITE_BLOCK.get())).pattern("BBB").pattern("BBB").pattern("BBB").define(Character.valueOf('B'), (ItemLike)AbyssItems.CRIMSONITE_INGOT.get()).unlockedBy("has_crimsonite_ingot", AbyssRecipeProvider.has(AbyssItems.CRIMSONITE_INGOT)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)AbyssItems.CRIMSONITE_INGOT.get()), (int)9).requires(AbyssBlocks.CRIMSONITE_BLOCK).unlockedBy("has_crimsonite_block", AbyssRecipeProvider.has(AbyssBlocks.CRIMSONITE_BLOCK)).save(recipeOutput);
        AbyssRecipeProvider.oreSmelting(recipeOutput, CRIMSONITE_SMELTABLES, RecipeCategory.MISC, (ItemLike)AbyssItems.CRIMSONITE_INGOT.get(), 0.25f, 200, "crimsonite");
        AbyssRecipeProvider.oreBlasting(recipeOutput, CRIMSONITE_SMELTABLES, RecipeCategory.MISC, (ItemLike)AbyssItems.CRIMSONITE_INGOT.get(), 0.25f, 100, "crimsonite");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)AbyssItems.CRIMSONITE_SWORD.get())).pattern(" I ").pattern(" I ").pattern(" S ").define(Character.valueOf('I'), (ItemLike)AbyssItems.CRIMSONITE_INGOT.get()).define(Character.valueOf('S'), (ItemLike)Items.STICK).unlockedBy("has_crimsonite_ingot", AbyssRecipeProvider.has(AbyssItems.CRIMSONITE_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)AbyssItems.CRIMSONITE_PICKAXE.get())).pattern("III").pattern(" S ").pattern(" S ").define(Character.valueOf('I'), (ItemLike)AbyssItems.CRIMSONITE_INGOT.get()).define(Character.valueOf('S'), (ItemLike)Items.STICK).unlockedBy("has_crimsonite_ingot", AbyssRecipeProvider.has(AbyssItems.CRIMSONITE_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)AbyssItems.CRIMSONITE_AXE.get())).pattern("II ").pattern("IS ").pattern(" S ").define(Character.valueOf('I'), (ItemLike)AbyssItems.CRIMSONITE_INGOT.get()).define(Character.valueOf('S'), (ItemLike)Items.STICK).unlockedBy("has_crimsonite_ingot", AbyssRecipeProvider.has(AbyssItems.CRIMSONITE_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)AbyssItems.CRIMSONITE_SHOVEL.get())).pattern(" I ").pattern(" S ").pattern(" S ").define(Character.valueOf('I'), (ItemLike)AbyssItems.CRIMSONITE_INGOT.get()).define(Character.valueOf('S'), (ItemLike)Items.STICK).unlockedBy("has_crimsonite_ingot", AbyssRecipeProvider.has(AbyssItems.CRIMSONITE_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)AbyssItems.CRIMSONITE_HOE.get())).pattern("II ").pattern(" S ").pattern(" S ").define(Character.valueOf('I'), (ItemLike)AbyssItems.CRIMSONITE_INGOT.get()).define(Character.valueOf('S'), (ItemLike)Items.STICK).unlockedBy("has_crimsonite_ingot", AbyssRecipeProvider.has(AbyssItems.CRIMSONITE_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)AbyssItems.CRIMSONITE_HELMET.get())).pattern("III").pattern("I I").define(Character.valueOf('I'), (ItemLike)AbyssItems.CRIMSONITE_INGOT.get()).unlockedBy("has_crimsonite_ingot", AbyssRecipeProvider.has(AbyssItems.CRIMSONITE_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)AbyssItems.CRIMSONITE_CHESTPLATE.get())).pattern("I I").pattern("III").pattern("III").define(Character.valueOf('I'), (ItemLike)AbyssItems.CRIMSONITE_INGOT.get()).unlockedBy("has_crimsonite_ingot", AbyssRecipeProvider.has(AbyssItems.CRIMSONITE_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)AbyssItems.CRIMSONITE_LEGGINGS.get())).pattern("III").pattern("I I").pattern("I I").define(Character.valueOf('I'), (ItemLike)AbyssItems.CRIMSONITE_INGOT.get()).unlockedBy("has_crimsonite_ingot", AbyssRecipeProvider.has(AbyssItems.CRIMSONITE_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)AbyssItems.CRIMSONITE_BOOTS.get())).pattern("I I").pattern("I I").define(Character.valueOf('I'), (ItemLike)AbyssItems.CRIMSONITE_INGOT.get()).unlockedBy("has_crimsonite_ingot", AbyssRecipeProvider.has(AbyssItems.CRIMSONITE_INGOT)).save(recipeOutput);
    }

    protected static void oreSmelting(RecipeOutput recipeOutput, List<ItemLike> pIngredients, RecipeCategory pCategory, ItemLike pResult, float pExperience, int pCookingTIme, String pGroup) {
        AbyssRecipeProvider.oreCooking(recipeOutput, RecipeSerializer.SMELTING_RECIPE, SmeltingRecipe::new, pIngredients, pCategory, pResult, pExperience, pCookingTIme, pGroup, "_from_smelting");
    }

    protected static void oreBlasting(RecipeOutput recipeOutput, List<ItemLike> pIngredients, RecipeCategory pCategory, ItemLike pResult, float pExperience, int pCookingTime, String pGroup) {
        AbyssRecipeProvider.oreCooking(recipeOutput, RecipeSerializer.BLASTING_RECIPE, BlastingRecipe::new, pIngredients, pCategory, pResult, pExperience, pCookingTime, pGroup, "_from_blasting");
    }

    protected static <T extends AbstractCookingRecipe> void oreCooking(RecipeOutput recipeOutput, RecipeSerializer<T> pCookingSerializer, AbstractCookingRecipe.Factory<T> factory, List<ItemLike> pIngredients, RecipeCategory pCategory, ItemLike pResult, float pExperience, int pCookingTime, String pGroup, String pRecipeName) {
        for (ItemLike itemlike : pIngredients) {
            SimpleCookingRecipeBuilder.generic((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{itemlike}), (RecipeCategory)pCategory, (ItemLike)pResult, (float)pExperience, (int)pCookingTime, pCookingSerializer, factory).group(pGroup).unlockedBy(AbyssRecipeProvider.getHasName((ItemLike)itemlike), AbyssRecipeProvider.has((ItemLike)itemlike)).save(recipeOutput, "abyssborne:" + AbyssRecipeProvider.getItemName((ItemLike)pResult) + pRecipeName + "_" + AbyssRecipeProvider.getItemName((ItemLike)itemlike));
        }
    }
}

