/*
 * Decompiled with CFR 0.152.
 */
package net.trique.abyssborne.datagen;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.trique.abyssborne.datagen.AbyssBlockLootTableProvider;
import net.trique.abyssborne.datagen.AbyssBlockStateProvider;
import net.trique.abyssborne.datagen.AbyssBlockTagProvider;
import net.trique.abyssborne.datagen.AbyssDatapackProvider;
import net.trique.abyssborne.datagen.AbyssItemModelProvider;
import net.trique.abyssborne.datagen.AbyssItemTagProvider;
import net.trique.abyssborne.datagen.AbyssRecipeProvider;

@EventBusSubscriber(modid="abyssborne")
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(true, (DataProvider)new AbyssDatapackProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(AbyssBlockLootTableProvider::new, LootContextParamSets.BLOCK)), lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new AbyssRecipeProvider(packOutput, lookupProvider));
        AbyssBlockTagProvider blockTagsProvider = new AbyssBlockTagProvider(packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new AbyssItemTagProvider(packOutput, lookupProvider, blockTagsProvider.contentsGetter(), existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new AbyssItemModelProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new AbyssBlockStateProvider(packOutput, existingFileHelper));
    }
}

