/*
 * Decompiled with CFR 0.152.
 */
package net.trique.abyssborne.material;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public final class AbyssFluidTypes {
    public static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((Registry)NeoForgeRegistries.FLUID_TYPES, (String)"abyssborne");
    public static final DeferredHolder<FluidType, FluidType> PURPLE_LAVA_TYPE = FLUID_TYPES.register("purple_lava", () -> new FluidType(FluidType.Properties.create().descriptionId("fluid.abyssborne.purple_lava").lightLevel(15).density(3000).viscosity(6000).temperature(1300).motionScale(0.0023).fallDistanceModifier(0.5f).canExtinguish(false).canDrown(false).canConvertToSource(false).canHydrate(false).canSwim(false).supportsBoating(false)){

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(this){

                public ResourceLocation getStillTexture() {
                    return ResourceLocation.fromNamespaceAndPath((String)"abyssborne", (String)"block/purple_lava_still");
                }

                public ResourceLocation getFlowingTexture() {
                    return ResourceLocation.fromNamespaceAndPath((String)"abyssborne", (String)"block/purple_lava_flow");
                }

                @Nullable
                public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                    return ResourceLocation.fromNamespaceAndPath((String)"abyssborne", (String)"textures/misc/purple_lava_overlay.png");
                }

                public void renderOverlay(Minecraft mc, PoseStack poseStack) {
                    ResourceLocation tex = this.getRenderOverlayTexture(mc);
                    if (tex == null || mc.player == null) {
                        return;
                    }
                    RenderSystem.setShader(GameRenderer::getPositionTexShader);
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)tex);
                    float alpha = 0.85f;
                    RenderSystem.enableBlend();
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                    Matrix4f mat = poseStack.last().pose();
                    Tesselator tesselator = Tesselator.getInstance();
                    BufferBuilder buf = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                    buf.addVertex(mat, -1.0f, -1.0f, -0.5f).setUv(1.0f, 1.0f);
                    buf.addVertex(mat, 1.0f, -1.0f, -0.5f).setUv(0.0f, 1.0f);
                    buf.addVertex(mat, 1.0f, 1.0f, -0.5f).setUv(0.0f, 0.0f);
                    buf.addVertex(mat, -1.0f, 1.0f, -0.5f).setUv(1.0f, 0.0f);
                    BufferUploader.drawWithShader((MeshData)buf.buildOrThrow());
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderSystem.disableBlend();
                }

                public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                    return new Vector3f(0.7f, 0.25f, 0.85f);
                }

                public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                    float near = Math.min(nearDistance + 0.5f, 2.0f);
                    float far = Math.min(farDistance, 12.0f);
                    RenderSystem.setShaderFogStart((float)near);
                    RenderSystem.setShaderFogEnd((float)far);
                    RenderSystem.setShaderFogShape((FogShape)shape);
                }
            });
        }
    });

    private AbyssFluidTypes() {
    }

    public static void register(IEventBus bus) {
        FLUID_TYPES.register(bus);
    }
}

