/*
 * Decompiled with CFR 0.152.
 */
package net.trique.abyssborne.material;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.LavaFluid;
import net.neoforged.neoforge.fluids.FluidType;
import net.trique.abyssborne.block.AbyssBlocks;
import net.trique.abyssborne.item.AbyssItems;
import net.trique.abyssborne.material.AbyssFluidTypes;
import net.trique.abyssborne.material.AbyssFluids;

public abstract class PurpleLavaFluid
extends LavaFluid {
    public ParticleOptions getDripParticle() {
        return ParticleTypes.FALLING_OBSIDIAN_TEAR;
    }

    public FluidType getFluidType() {
        return (FluidType)AbyssFluidTypes.PURPLE_LAVA_TYPE.get();
    }

    public Fluid getFlowing() {
        return AbyssFluids.FLOWING_PURPLE_LAVA;
    }

    public Fluid getSource() {
        return AbyssFluids.PURPLE_LAVA;
    }

    public BlockState createLegacyBlock(FluidState state) {
        return (BlockState)((LiquidBlock)AbyssBlocks.PURPLE_LAVA.get()).defaultBlockState().setValue((Property)LiquidBlock.LEVEL, (Comparable)Integer.valueOf(PurpleLavaFluid.getLegacyLevel((FluidState)state)));
    }

    public Optional<SoundEvent> getPickupSound() {
        return Optional.of(SoundEvents.BUCKET_FILL_LAVA);
    }

    public Item getBucket() {
        return (Item)AbyssItems.PURPLE_LAVA_BUCKET.get();
    }

    public boolean isSame(Fluid fluid) {
        return fluid == AbyssFluids.PURPLE_LAVA || fluid == AbyssFluids.FLOWING_PURPLE_LAVA;
    }

    public void randomTick(Level level, BlockPos pos, FluidState state, RandomSource random) {
    }

    public void animateTick(Level level, BlockPos pos, FluidState state, RandomSource random) {
    }

    public static class Source
    extends PurpleLavaFluid {
        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends PurpleLavaFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }
}

