/*
 * Decompiled with CFR 0.152.
 */
package net.trique.abyssborne.worldgen;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.trique.abyssborne.tag.AbyssBiomeTags;
import net.trique.abyssborne.worldgen.AbyssPlacedFeatures;

public class AbyssBiomeModifiers {
    public static final ResourceKey<BiomeModifier> ADD_AMARYLLIUM_ORE = AbyssBiomeModifiers.registerKey("add_amaryllium_ore");
    public static final ResourceKey<BiomeModifier> ADD_CRIMSONITE_ORE = AbyssBiomeModifiers.registerKey("add_crimsonite_ore");
    public static final ResourceKey<BiomeModifier> ADD_NIGHT_ROOTS = AbyssBiomeModifiers.registerKey("add_night_roots");
    public static final ResourceKey<BiomeModifier> ADD_AZURE_ROOTS = AbyssBiomeModifiers.registerKey("add_azure_roots");
    public static final ResourceKey<BiomeModifier> ADD_AMBER_ROOTS = AbyssBiomeModifiers.registerKey("add_amber_roots");
    public static final ResourceKey<BiomeModifier> ADD_NIGHT_FUNGUS = AbyssBiomeModifiers.registerKey("add_night_fungus");
    public static final ResourceKey<BiomeModifier> ADD_AZURE_FUNGUS = AbyssBiomeModifiers.registerKey("add_azure_fungus");
    public static final ResourceKey<BiomeModifier> ADD_AMBER_FUNGUS = AbyssBiomeModifiers.registerKey("add_amber_fungus");
    public static final ResourceKey<BiomeModifier> ADD_NIGHT_BUSH = AbyssBiomeModifiers.registerKey("add_night_bush");
    public static final ResourceKey<BiomeModifier> ADD_AZURE_BUSH = AbyssBiomeModifiers.registerKey("add_azure_bush");
    public static final ResourceKey<BiomeModifier> ADD_AMBER_BUSH = AbyssBiomeModifiers.registerKey("add_amber_bush");
    public static final ResourceKey<BiomeModifier> ADD_STRANGE_CLUSTER = AbyssBiomeModifiers.registerKey("add_strange_cluster");
    public static final ResourceKey<BiomeModifier> ADD_WEIRD_CLUSTER = AbyssBiomeModifiers.registerKey("add_weird_cluster");
    public static final ResourceKey<BiomeModifier> ADD_ODD_CLUSTER = AbyssBiomeModifiers.registerKey("add_odd_cluster");
    public static final ResourceKey<BiomeModifier> ADD_AZURE_MASS = AbyssBiomeModifiers.registerKey("add_azure_mass");
    public static final ResourceKey<BiomeModifier> ADD_NIGHT_MASS = AbyssBiomeModifiers.registerKey("add_night_mass");
    public static final ResourceKey<BiomeModifier> ADD_AMBER_MASS = AbyssBiomeModifiers.registerKey("add_amber_mass");

    public static void bootstrap(BootstrapContext<BiomeModifier> context) {
        HolderGetter placedFeatures = context.lookup(Registries.PLACED_FEATURE);
        HolderGetter biomes = context.lookup(Registries.BIOME);
        context.register(ADD_AMARYLLIUM_ORE, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(AbyssBiomeTags.IS_ABYSS), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(AbyssPlacedFeatures.AMARYLLIUM_ORE_PLACED_KEY)}), GenerationStep.Decoration.UNDERGROUND_ORES));
        context.register(ADD_CRIMSONITE_ORE, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(AbyssBiomeTags.IS_ABYSS), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(AbyssPlacedFeatures.CRIMSONITE_ORE_PLACED_KEY)}), GenerationStep.Decoration.UNDERGROUND_ORES));
        context.register(ADD_NIGHT_ROOTS, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(AbyssBiomeTags.IS_NIGHT_GROVE), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(AbyssPlacedFeatures.NIGHT_ROOTS_PLACED)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_AZURE_ROOTS, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(AbyssBiomeTags.IS_AZURE_GROVE), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(AbyssPlacedFeatures.AZURE_ROOTS_PLACED)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_AMBER_ROOTS, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(AbyssBiomeTags.IS_AMBER_GROVE), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(AbyssPlacedFeatures.AMBER_ROOTS_PLACED)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_NIGHT_FUNGUS, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(AbyssBiomeTags.IS_NIGHT_GROVE), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(AbyssPlacedFeatures.NIGHT_FUNGUS_PLACED)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_AZURE_FUNGUS, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(AbyssBiomeTags.IS_AZURE_GROVE), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(AbyssPlacedFeatures.AZURE_FUNGUS_PLACED)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_AMBER_FUNGUS, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(AbyssBiomeTags.IS_AMBER_GROVE), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(AbyssPlacedFeatures.AMBER_FUNGUS_PLACED)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_NIGHT_BUSH, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(AbyssBiomeTags.IS_NIGHT_GROVE), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(AbyssPlacedFeatures.NIGHT_BUSH_PLACED)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_AZURE_BUSH, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(AbyssBiomeTags.IS_AZURE_GROVE), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(AbyssPlacedFeatures.AZURE_BUSH_PLACED)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_AMBER_BUSH, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(AbyssBiomeTags.IS_AMBER_GROVE), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(AbyssPlacedFeatures.AMBER_BUSH_PLACED)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_STRANGE_CLUSTER, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(AbyssBiomeTags.IS_CRYSTAL_CANYON), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(AbyssPlacedFeatures.STRANGE_CLUSTER_PLACED)}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        context.register(ADD_WEIRD_CLUSTER, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(AbyssBiomeTags.IS_CRYSTAL_CANYON), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(AbyssPlacedFeatures.WEIRD_CLUSTER_PLACED)}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        context.register(ADD_ODD_CLUSTER, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(AbyssBiomeTags.IS_CRYSTAL_CANYON), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(AbyssPlacedFeatures.ODD_CLUSTER_PLACED)}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        context.register(ADD_AZURE_MASS, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(AbyssBiomeTags.IS_AZURE_GROVE), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(AbyssPlacedFeatures.AZURE_MASS_PLACED_KEY)}), GenerationStep.Decoration.UNDERGROUND_ORES));
        context.register(ADD_NIGHT_MASS, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(AbyssBiomeTags.IS_NIGHT_GROVE), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(AbyssPlacedFeatures.NIGHT_MASS_PLACED_KEY)}), GenerationStep.Decoration.UNDERGROUND_ORES));
        context.register(ADD_AMBER_MASS, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(AbyssBiomeTags.IS_AMBER_GROVE), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(AbyssPlacedFeatures.AMBER_MASS_PLACED_KEY)}), GenerationStep.Decoration.UNDERGROUND_ORES));
    }

    private static ResourceKey<BiomeModifier> registerKey(String name) {
        return ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"abyssborne", (String)name));
    }
}

