/*
 * Decompiled with CFR 0.152.
 */
package net.trique.abyssborne.worldgen;

import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.trique.abyssborne.block.AbyssBlocks;

public class AbyssConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> AMARYLLIUM_ORE_KEY = AbyssConfiguredFeatures.registerKey("amaryllium_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CRIMSONITE_ORE_KEY = AbyssConfiguredFeatures.registerKey("crimsonite_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NIGHT_ROOTS_PATCH = AbyssConfiguredFeatures.registerKey("night_roots_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> AZURE_ROOTS_PATCH = AbyssConfiguredFeatures.registerKey("azure_roots_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> AMBER_ROOTS_PATCH = AbyssConfiguredFeatures.registerKey("amber_roots_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NIGHT_FUNGUS_PATCH = AbyssConfiguredFeatures.registerKey("night_fungus_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> AZURE_FUNGUS_PATCH = AbyssConfiguredFeatures.registerKey("azure_fungus_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> AMBER_FUNGUS_PATCH = AbyssConfiguredFeatures.registerKey("amber_fungus_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NIGHT_BUSH_PATCH = AbyssConfiguredFeatures.registerKey("night_bush_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> AZURE_BUSH_PATCH = AbyssConfiguredFeatures.registerKey("azure_bush_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> AMBER_BUSH_PATCH = AbyssConfiguredFeatures.registerKey("amber_bush_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> STRANGE_CLUSTER_KEY = AbyssConfiguredFeatures.registerKey("strange_cluster_key");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WEIRD_CLUSTER_KEY = AbyssConfiguredFeatures.registerKey("weird_cluster_key");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ODD_CLUSTER_KEY = AbyssConfiguredFeatures.registerKey("odd_cluster_key");
    public static final ResourceKey<ConfiguredFeature<?, ?>> AZURE_MASS_KEY = AbyssConfiguredFeatures.registerKey("azure_mass");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NIGHT_MASS_KEY = AbyssConfiguredFeatures.registerKey("night_mass");
    public static final ResourceKey<ConfiguredFeature<?, ?>> AMBER_MASS_KEY = AbyssConfiguredFeatures.registerKey("amber_mass");

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        BlockMatchTest abyssReplaceables = new BlockMatchTest((Block)AbyssBlocks.ABYSSTONE.get());
        AbyssConfiguredFeatures.register(context, AMARYLLIUM_ORE_KEY, Feature.ORE, new OreConfiguration((RuleTest)abyssReplaceables, ((Block)AbyssBlocks.ABYSS_AMARYLLIUM_ORE.get()).defaultBlockState(), 4));
        AbyssConfiguredFeatures.register(context, CRIMSONITE_ORE_KEY, Feature.ORE, new OreConfiguration((RuleTest)abyssReplaceables, ((Block)AbyssBlocks.ABYSS_CRIMSONITE_ORE.get()).defaultBlockState(), 4));
        FeatureUtils.register(context, NIGHT_ROOTS_PATCH, (Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((Block)AbyssBlocks.NIGHT_ROOTS.get()).defaultBlockState())), List.of((Block)AbyssBlocks.NIGHT_NYLIUM.get(), (Block)AbyssBlocks.ABYSSTONE.get())));
        FeatureUtils.register(context, AZURE_ROOTS_PATCH, (Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((Block)AbyssBlocks.AZURE_ROOTS.get()).defaultBlockState())), List.of((Block)AbyssBlocks.AZURE_NYLIUM.get(), (Block)AbyssBlocks.ABYSSTONE.get())));
        FeatureUtils.register(context, AMBER_ROOTS_PATCH, (Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((Block)AbyssBlocks.AMBER_ROOTS.get()).defaultBlockState())), List.of((Block)AbyssBlocks.AMBER_NYLIUM.get(), (Block)AbyssBlocks.ABYSSTONE.get())));
        FeatureUtils.register(context, NIGHT_FUNGUS_PATCH, (Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((Block)AbyssBlocks.NIGHT_FUNGUS.get()).defaultBlockState())), List.of((Block)AbyssBlocks.NIGHT_NYLIUM.get(), (Block)AbyssBlocks.ABYSSTONE.get())));
        FeatureUtils.register(context, AZURE_FUNGUS_PATCH, (Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((Block)AbyssBlocks.AZURE_FUNGUS.get()).defaultBlockState())), List.of((Block)AbyssBlocks.AZURE_NYLIUM.get(), (Block)AbyssBlocks.ABYSSTONE.get())));
        FeatureUtils.register(context, AMBER_FUNGUS_PATCH, (Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((Block)AbyssBlocks.AMBER_FUNGUS.get()).defaultBlockState())), List.of((Block)AbyssBlocks.AMBER_NYLIUM.get(), (Block)AbyssBlocks.ABYSSTONE.get())));
        FeatureUtils.register(context, NIGHT_BUSH_PATCH, (Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((Block)AbyssBlocks.NIGHT_BUSH.get()).defaultBlockState())), List.of((Block)AbyssBlocks.NIGHT_NYLIUM.get(), (Block)AbyssBlocks.ABYSSTONE.get())));
        FeatureUtils.register(context, AZURE_BUSH_PATCH, (Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((Block)AbyssBlocks.AZURE_BUSH.get()).defaultBlockState())), List.of((Block)AbyssBlocks.AZURE_NYLIUM.get(), (Block)AbyssBlocks.ABYSSTONE.get())));
        FeatureUtils.register(context, AMBER_BUSH_PATCH, (Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((Block)AbyssBlocks.AMBER_BUSH.get()).defaultBlockState())), List.of((Block)AbyssBlocks.AMBER_NYLIUM.get(), (Block)AbyssBlocks.ABYSSTONE.get())));
        FeatureUtils.register(context, STRANGE_CLUSTER_KEY, (Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((Block)AbyssBlocks.STRANGE_CLUSTER.get()).defaultBlockState())), List.of((Block)AbyssBlocks.ABYSSTONE.get())));
        FeatureUtils.register(context, WEIRD_CLUSTER_KEY, (Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((Block)AbyssBlocks.WEIRD_CLUSTER.get()).defaultBlockState())), List.of((Block)AbyssBlocks.ABYSSTONE.get())));
        FeatureUtils.register(context, ODD_CLUSTER_KEY, (Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((Block)AbyssBlocks.ODD_CLUSTER.get()).defaultBlockState())), List.of((Block)AbyssBlocks.ABYSSTONE.get())));
        AbyssConfiguredFeatures.register(context, AZURE_MASS_KEY, Feature.ORE, new OreConfiguration((RuleTest)abyssReplaceables, ((Block)AbyssBlocks.AZURE_NYLIUM_MASS.get()).defaultBlockState(), 8));
        AbyssConfiguredFeatures.register(context, NIGHT_MASS_KEY, Feature.ORE, new OreConfiguration((RuleTest)abyssReplaceables, ((Block)AbyssBlocks.NIGHT_NYLIUM_MASS.get()).defaultBlockState(), 8));
        AbyssConfiguredFeatures.register(context, AMBER_MASS_KEY, Feature.ORE, new OreConfiguration((RuleTest)abyssReplaceables, ((Block)AbyssBlocks.AMBER_NYLIUM_MASS.get()).defaultBlockState(), 8));
    }

    private static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"abyssborne", (String)name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.register(key, (Object)new ConfiguredFeature(feature, configuration));
    }
}

