/*
 * Decompiled with CFR 0.152.
 */
package net.trique.abyssborne.worldgen;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.trique.abyssborne.worldgen.AbyssConfiguredFeatures;
import net.trique.abyssborne.worldgen.AbyssOrePlacement;

public class AbyssPlacedFeatures {
    public static final ResourceKey<PlacedFeature> AMARYLLIUM_ORE_PLACED_KEY = AbyssPlacedFeatures.registerKey("amaryllium_ore_placed");
    public static final ResourceKey<PlacedFeature> CRIMSONITE_ORE_PLACED_KEY = AbyssPlacedFeatures.registerKey("crimsonite_ore_placed");
    public static final ResourceKey<PlacedFeature> NIGHT_ROOTS_PLACED = AbyssPlacedFeatures.registerKey("night_roots_placed");
    public static final ResourceKey<PlacedFeature> AZURE_ROOTS_PLACED = AbyssPlacedFeatures.registerKey("azure_roots_placed");
    public static final ResourceKey<PlacedFeature> AMBER_ROOTS_PLACED = AbyssPlacedFeatures.registerKey("amber_roots_placed");
    public static final ResourceKey<PlacedFeature> NIGHT_FUNGUS_PLACED = AbyssPlacedFeatures.registerKey("night_fungus_placed");
    public static final ResourceKey<PlacedFeature> AZURE_FUNGUS_PLACED = AbyssPlacedFeatures.registerKey("azure_fungus_placed");
    public static final ResourceKey<PlacedFeature> AMBER_FUNGUS_PLACED = AbyssPlacedFeatures.registerKey("amber_fungus_placed");
    public static final ResourceKey<PlacedFeature> NIGHT_BUSH_PLACED = AbyssPlacedFeatures.registerKey("night_bush_placed");
    public static final ResourceKey<PlacedFeature> AZURE_BUSH_PLACED = AbyssPlacedFeatures.registerKey("azure_bush_placed");
    public static final ResourceKey<PlacedFeature> AMBER_BUSH_PLACED = AbyssPlacedFeatures.registerKey("amber_bush_placed");
    public static final ResourceKey<PlacedFeature> STRANGE_CLUSTER_PLACED = AbyssPlacedFeatures.registerKey("strange_cluster_placed");
    public static final ResourceKey<PlacedFeature> WEIRD_CLUSTER_PLACED = AbyssPlacedFeatures.registerKey("weird_cluster_placed");
    public static final ResourceKey<PlacedFeature> ODD_CLUSTER_PLACED = AbyssPlacedFeatures.registerKey("odd_cluster_placed");
    public static final ResourceKey<PlacedFeature> AZURE_MASS_PLACED_KEY = AbyssPlacedFeatures.registerKey("azure_mass_placed");
    public static final ResourceKey<PlacedFeature> NIGHT_MASS_PLACED_KEY = AbyssPlacedFeatures.registerKey("night_mass_placed");
    public static final ResourceKey<PlacedFeature> AMBER_MASS_PLACED_KEY = AbyssPlacedFeatures.registerKey("amber_mass_placed");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configured = context.lookup(Registries.CONFIGURED_FEATURE);
        AbyssPlacedFeatures.register(context, AMARYLLIUM_ORE_PLACED_KEY, configured.getOrThrow(AbyssConfiguredFeatures.AMARYLLIUM_ORE_KEY), AbyssOrePlacement.commonOrePlacement(15, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)0), (VerticalAnchor)VerticalAnchor.absolute((int)96))));
        AbyssPlacedFeatures.register(context, CRIMSONITE_ORE_PLACED_KEY, configured.getOrThrow(AbyssConfiguredFeatures.CRIMSONITE_ORE_KEY), AbyssOrePlacement.commonOrePlacement(15, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)0), (VerticalAnchor)VerticalAnchor.absolute((int)96))));
        AbyssPlacedFeatures.register(context, NIGHT_ROOTS_PLACED, configured.getOrThrow(AbyssConfiguredFeatures.NIGHT_ROOTS_PATCH), AbyssPlacedFeatures.rootsModifiers(1));
        AbyssPlacedFeatures.register(context, AZURE_ROOTS_PLACED, configured.getOrThrow(AbyssConfiguredFeatures.AZURE_ROOTS_PATCH), AbyssPlacedFeatures.rootsModifiers(1));
        AbyssPlacedFeatures.register(context, AMBER_ROOTS_PLACED, configured.getOrThrow(AbyssConfiguredFeatures.AMBER_ROOTS_PATCH), AbyssPlacedFeatures.rootsModifiers(1));
        AbyssPlacedFeatures.register(context, NIGHT_FUNGUS_PLACED, configured.getOrThrow(AbyssConfiguredFeatures.NIGHT_FUNGUS_PATCH), AbyssPlacedFeatures.rootsModifiers(1));
        AbyssPlacedFeatures.register(context, AZURE_FUNGUS_PLACED, configured.getOrThrow(AbyssConfiguredFeatures.AZURE_FUNGUS_PATCH), AbyssPlacedFeatures.rootsModifiers(1));
        AbyssPlacedFeatures.register(context, AMBER_FUNGUS_PLACED, configured.getOrThrow(AbyssConfiguredFeatures.AMBER_FUNGUS_PATCH), AbyssPlacedFeatures.rootsModifiers(1));
        AbyssPlacedFeatures.register(context, NIGHT_BUSH_PLACED, configured.getOrThrow(AbyssConfiguredFeatures.NIGHT_BUSH_PATCH), AbyssPlacedFeatures.rootsModifiers(1));
        AbyssPlacedFeatures.register(context, AZURE_BUSH_PLACED, configured.getOrThrow(AbyssConfiguredFeatures.AZURE_BUSH_PATCH), AbyssPlacedFeatures.rootsModifiers(1));
        AbyssPlacedFeatures.register(context, AMBER_BUSH_PLACED, configured.getOrThrow(AbyssConfiguredFeatures.AMBER_BUSH_PATCH), AbyssPlacedFeatures.rootsModifiers(1));
        AbyssPlacedFeatures.register(context, STRANGE_CLUSTER_PLACED, configured.getOrThrow(AbyssConfiguredFeatures.STRANGE_CLUSTER_KEY), AbyssPlacedFeatures.rootsModifiers(1));
        AbyssPlacedFeatures.register(context, WEIRD_CLUSTER_PLACED, configured.getOrThrow(AbyssConfiguredFeatures.WEIRD_CLUSTER_KEY), AbyssPlacedFeatures.rootsModifiers(1));
        AbyssPlacedFeatures.register(context, ODD_CLUSTER_PLACED, configured.getOrThrow(AbyssConfiguredFeatures.ODD_CLUSTER_KEY), AbyssPlacedFeatures.rootsModifiers(1));
        AbyssPlacedFeatures.register(context, AZURE_MASS_PLACED_KEY, configured.getOrThrow(AbyssConfiguredFeatures.AZURE_MASS_KEY), AbyssOrePlacement.commonOrePlacement(30, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)32), (VerticalAnchor)VerticalAnchor.absolute((int)128))));
        AbyssPlacedFeatures.register(context, NIGHT_MASS_PLACED_KEY, configured.getOrThrow(AbyssConfiguredFeatures.NIGHT_MASS_KEY), AbyssOrePlacement.commonOrePlacement(30, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)32), (VerticalAnchor)VerticalAnchor.absolute((int)128))));
        AbyssPlacedFeatures.register(context, AMBER_MASS_PLACED_KEY, configured.getOrThrow(AbyssConfiguredFeatures.AMBER_MASS_KEY), AbyssOrePlacement.commonOrePlacement(30, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)32), (VerticalAnchor)VerticalAnchor.absolute((int)128))));
    }

    private static List<PlacementModifier> rootsModifiers(int averageOnceEvery) {
        return List.of(RarityFilter.onAverageOnceEvery((int)averageOnceEvery), InSquarePlacement.spread(), PlacementUtils.FULL_RANGE, BiomeFilter.biome());
    }

    private static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"abyssborne", (String)name));
    }

    private static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuredFeature, List<PlacementModifier> modifiers) {
        context.register(key, (Object)new PlacedFeature(configuredFeature, List.copyOf(modifiers)));
    }
}

