/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn;

import dev.brighten.antivpn.api.PlayerExecutor;
import dev.brighten.antivpn.api.VPNConfig;
import dev.brighten.antivpn.api.VPNExecutor;
import dev.brighten.antivpn.command.Command;
import dev.brighten.antivpn.command.impl.AntiVPNCommand;
import dev.brighten.antivpn.database.VPNDatabase;
import dev.brighten.antivpn.database.local.H2VPN;
import dev.brighten.antivpn.database.mongo.MongoVPN;
import dev.brighten.antivpn.database.sql.MySqlVPN;
import dev.brighten.antivpn.depends.LibraryLoader;
import dev.brighten.antivpn.depends.MavenLibraries;
import dev.brighten.antivpn.depends.MavenLibrary;
import dev.brighten.antivpn.depends.Relocate;
import dev.brighten.antivpn.message.MessageHandler;
import dev.brighten.antivpn.utils.ConfigDefault;
import dev.brighten.antivpn.utils.MiscUtils;
import dev.brighten.antivpn.utils.config.Configuration;
import dev.brighten.antivpn.utils.config.ConfigurationProvider;
import dev.brighten.antivpn.utils.config.YamlConfiguration;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.List;

@MavenLibraries(value={@MavenLibrary(groupId="com.h2database", artifactId="h2", version="2.2.220", relocations={@Relocate(from="org.\\h2", to="dev.brighten.antivpn.shaded.org.h2")}), @MavenLibrary(groupId="org.mongodb", artifactId="mongo-java-driver", version="3.12.14", relocations={@Relocate(from="com.\\mongodb", to="dev.brighten.antivpn.shaded.com.mongodb"), @Relocate(from="org\\.bson", to="dev.brighten.antivpn.shaded.org.bson")}), @MavenLibrary(groupId="com.mysql", artifactId="mysql-connector-j", version="9.1.0", relocations={@Relocate(from="com.my\\sql.cj", to="dev.brighten.antivpn.shaded.com.mysql.cj"), @Relocate(from="com.my\\sql.jdbc", to="dev.brighten.antivpn.shaded.com.mysql.jdbc")}), @MavenLibrary(groupId="com.\\github\\.ben-manes\\.caffeine", artifactId="caffeine", version="3.1.8", relocations={@Relocate(from="com\\.github\\.benmanes\\.caffeine", to="dev.brighten.antivpn.shaded.com.github.benmanes.caffeine")})})
public class AntiVPN {
    private static AntiVPN INSTANCE;
    private VPNConfig vpnConfig;
    private VPNExecutor executor;
    private PlayerExecutor playerExecutor;
    private VPNDatabase database;
    private MessageHandler messageHandler;
    private Configuration config;
    private List<Command> commands = new ArrayList<Command>();
    public int detections;
    public int checked;
    private File pluginFolder;

    public static void start(VPNExecutor executor, PlayerExecutor playerExecutor, File pluginFolder) {
        INSTANCE = new AntiVPN();
        AntiVPN.INSTANCE.pluginFolder = pluginFolder;
        AntiVPN.INSTANCE.executor = executor;
        AntiVPN.INSTANCE.playerExecutor = playerExecutor;
        LibraryLoader.loadAll(INSTANCE);
        try {
            File configFile = new File(pluginFolder, "config.yml");
            if (!configFile.exists()) {
                if (configFile.getParentFile().mkdirs()) {
                    AntiVPN.getInstance().getExecutor().log("Created plugin folder!", new Object[0]);
                }
                MiscUtils.copy(INSTANCE.getResource("config.yml"), configFile);
            }
            AntiVPN.INSTANCE.config = ConfigurationProvider.getProvider(YamlConfiguration.class).load(configFile);
        }
        catch (IOException e) {
            AntiVPN.getInstance().getExecutor().logException("Could not load config.yml, plugin disabling...", e);
            executor.disablePlugin();
            return;
        }
        AntiVPN.INSTANCE.vpnConfig = new VPNConfig();
        AntiVPN.INSTANCE.executor.registerListeners();
        AntiVPN.INSTANCE.vpnConfig.update();
        AntiVPN.INSTANCE.messageHandler = new MessageHandler();
        try {
            switch (AntiVPN.INSTANCE.vpnConfig.getDatabaseType().toLowerCase()) {
                case "h2": 
                case "local": 
                case "flatfile": {
                    AntiVPN.getInstance().getExecutor().log("Using databaseType H2...", new Object[0]);
                    AntiVPN.INSTANCE.database = new H2VPN();
                    AntiVPN.INSTANCE.database.init();
                    break;
                }
                case "mysql": 
                case "sql": {
                    AntiVPN.getInstance().getExecutor().log("Using databaseType MySQL...", new Object[0]);
                    AntiVPN.INSTANCE.database = new MySqlVPN();
                    AntiVPN.INSTANCE.database.init();
                    break;
                }
                case "mongo": 
                case "mongodb": 
                case "mongod": {
                    AntiVPN.INSTANCE.database = new MongoVPN();
                    AntiVPN.INSTANCE.database.init();
                    break;
                }
                default: {
                    AntiVPN.getInstance().getExecutor().log("Could not find database type \"" + AntiVPN.INSTANCE.vpnConfig.getDatabaseType() + "\". Options: [MySQL]", new Object[0]);
                    break;
                }
            }
        }
        catch (Exception e) {
            AntiVPN.getInstance().getExecutor().logException("Could not initialize database, plugin disabling...", e);
            executor.disablePlugin();
            return;
        }
        INSTANCE.registerCommands();
        playerExecutor.getOnlinePlayers().forEach(player -> {
            if (player.hasPermission("antivpn.command.alerts")) {
                AntiVPN.INSTANCE.database.alertsState(player.getUuid(), player::setAlertsEnabled);
            }
        });
        AntiVPN.getInstance().getMessageHandler().initStrings(vpnString -> new ConfigDefault<String>(vpnString.getDefaultMessage(), "messages." + vpnString.getKey(), AntiVPN.getInstance()).get());
        AntiVPN.getInstance().getMessageHandler().reloadStrings();
        AntiVPN.getInstance().getExecutor().startKickChecks();
    }

    public InputStream getResource(String filename) {
        if (filename == null) {
            throw new IllegalArgumentException("Filename cannot be null");
        }
        try {
            URL url = this.executor.getClass().getClassLoader().getResource(filename);
            if (url == null) {
                return null;
            }
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            return connection.getInputStream();
        }
        catch (IOException var4) {
            return null;
        }
    }

    public void stop() {
        if (this.database instanceof H2VPN) {
            this.database.shutdown();
            try {
                Driver driver = DriverManager.getDriver("jdbc:h2:");
                if (driver != null) {
                    DriverManager.deregisterDriver(driver);
                }
            }
            catch (Exception e) {
                this.executor.log("Failed to deregister H2 driver: " + e.getMessage(), new Object[0]);
            }
        }
        VPNExecutor.threadExecutor.shutdown();
        if (this.database != null) {
            this.database.shutdown();
        }
    }

    public void reloadDatabase() {
        this.database.shutdown();
        switch (AntiVPN.getInstance().getVpnConfig().getDatabaseType().toLowerCase()) {
            case "h2": 
            case "local": 
            case "flatfile": {
                AntiVPN.getInstance().getExecutor().log("Using databaseType H2...", new Object[0]);
                AntiVPN.INSTANCE.database = new H2VPN();
                AntiVPN.INSTANCE.database.init();
                break;
            }
            case "mysql": 
            case "sql": {
                AntiVPN.getInstance().getExecutor().log("Using databaseType MySQL...", new Object[0]);
                AntiVPN.INSTANCE.database = new MySqlVPN();
                AntiVPN.INSTANCE.database.init();
                break;
            }
            case "mongo": 
            case "mongodb": 
            case "mongod": {
                AntiVPN.INSTANCE.database = new MongoVPN();
                AntiVPN.INSTANCE.database.init();
                break;
            }
            default: {
                AntiVPN.getInstance().getExecutor().log("Could not find database type \"" + AntiVPN.INSTANCE.vpnConfig.getDatabaseType() + "\". Options: [MySQL]", new Object[0]);
            }
        }
    }

    public static AntiVPN getInstance() {
        assert (INSTANCE != null) : "AntiVPN has not been initialized!";
        return INSTANCE;
    }

    public void saveConfig() {
        try {
            ConfigurationProvider.getProvider(YamlConfiguration.class).save(this.getConfig(), new File(this.pluginFolder.getPath() + File.separator + "config.yml"));
        }
        catch (IOException e) {
            AntiVPN.getInstance().getExecutor().logException(e);
        }
    }

    public void reloadConfig() {
        try {
            this.config = ConfigurationProvider.getProvider(YamlConfiguration.class).load(new File(this.pluginFolder.getPath() + File.separator + "config.yml"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void registerCommands() {
        this.commands.add(new AntiVPNCommand());
    }

    public VPNConfig getVpnConfig() {
        return this.vpnConfig;
    }

    public VPNExecutor getExecutor() {
        return this.executor;
    }

    public PlayerExecutor getPlayerExecutor() {
        return this.playerExecutor;
    }

    public VPNDatabase getDatabase() {
        return this.database;
    }

    public MessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public List<Command> getCommands() {
        return this.commands;
    }

    public int getDetections() {
        return this.detections;
    }

    public int getChecked() {
        return this.checked;
    }

    public File getPluginFolder() {
        return this.pluginFolder;
    }

    private void setVpnConfig(VPNConfig vpnConfig) {
        this.vpnConfig = vpnConfig;
    }

    private void setExecutor(VPNExecutor executor) {
        this.executor = executor;
    }

    private void setPlayerExecutor(PlayerExecutor playerExecutor) {
        this.playerExecutor = playerExecutor;
    }

    private void setDatabase(VPNDatabase database) {
        this.database = database;
    }

    private void setMessageHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    private void setConfig(Configuration config) {
        this.config = config;
    }

    private void setCommands(List<Command> commands) {
        this.commands = commands;
    }

    private void setDetections(int detections) {
        this.detections = detections;
    }

    private void setChecked(int checked) {
        this.checked = checked;
    }

    private void setPluginFolder(File pluginFolder) {
        this.pluginFolder = pluginFolder;
    }
}

