/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.api;

import dev.brighten.antivpn.AntiVPN;
import dev.brighten.antivpn.api.CheckResult;
import dev.brighten.antivpn.api.ResultType;
import dev.brighten.antivpn.shaded.com.github.benmanes.caffeine.cache.Cache;
import dev.brighten.antivpn.shaded.com.github.benmanes.caffeine.cache.Caffeine;
import dev.brighten.antivpn.web.objects.VPNResponse;
import java.net.InetAddress;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.logging.Level;

public abstract class APIPlayer {
    private final UUID uuid;
    private final String name;
    private final InetAddress ip;
    private boolean alertsEnabled;
    private static final Cache<String, CheckResult> checkResultCache = Caffeine.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).maximumSize(2000L).build();

    public APIPlayer(UUID uuid, String name, InetAddress ip) {
        this.uuid = uuid;
        this.name = name;
        this.ip = ip;
    }

    public abstract void sendMessage(String var1);

    public abstract void kickPlayer(String var1);

    public abstract boolean hasPermission(String var1);

    public void updateAlertsState() {
        AntiVPN.getInstance().getDatabase().updateAlertsState(this.uuid, this.alertsEnabled);
    }

    public CheckResult checkPlayer(Consumer<CheckResult> onKick) {
        block5: {
            block4: {
                if (this.hasPermission("antivpn.bypass") || this.uuid != null && AntiVPN.getInstance().getExecutor().isWhitelisted(this.uuid) || AntiVPN.getInstance().getExecutor().isWhitelisted(this.ip.getHostAddress())) break block4;
                if (!AntiVPN.getInstance().getVpnConfig().getPrefixWhitelists().stream().anyMatch(this.name::startsWith)) break block5;
            }
            return new CheckResult(null, ResultType.WHITELISTED);
        }
        CheckResult cachedResult = checkResultCache.getIfPresent(this.ip.getHostAddress());
        if (cachedResult != null && cachedResult.response().getIp().equals(this.ip.getHostAddress())) {
            AntiVPN.getInstance().getExecutor().log(Level.FINE, "Cached result for " + this.ip.getHostAddress() + " is " + String.valueOf((Object)cachedResult.resultType()), new Object[0]);
            return cachedResult;
        }
        AntiVPN.getInstance().getExecutor().checkIp(this.ip.getHostAddress()).thenAccept(result -> {
            if (!result.isSuccess()) {
                AntiVPN.getInstance().getExecutor().log(Level.WARNING, "The API query was not a success! You may need to upgrade your license on https://funkemunky.cc/shop", new Object[0]);
            }
            CheckResult checkResult = !AntiVPN.getInstance().getVpnConfig().countryList().isEmpty() && (this.uuid == null || !AntiVPN.getInstance().getExecutor().isWhitelisted(this.uuid)) && !AntiVPN.getInstance().getExecutor().isWhitelisted(this.ip.getHostAddress()) && AntiVPN.getInstance().getVpnConfig().countryList().contains(result.getCountryCode()) != AntiVPN.getInstance().getVpnConfig().whitelistCountries() ? new CheckResult((VPNResponse)result, ResultType.DENIED_COUNTRY) : (result.isProxy() ? new CheckResult((VPNResponse)result, ResultType.DENIED_PROXY) : new CheckResult((VPNResponse)result, ResultType.ALLOWED));
            AntiVPN.getInstance().getExecutor().log(Level.FINE, "Result for " + this.ip.getHostAddress() + " is " + String.valueOf((Object)checkResult.resultType()), new Object[0]);
            checkResultCache.put(this.ip.getHostAddress(), checkResult);
            onKick.accept(checkResult);
            ++AntiVPN.getInstance().checked;
        });
        return new CheckResult(null, ResultType.UNKNOWN);
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public InetAddress getIp() {
        return this.ip;
    }

    public boolean isAlertsEnabled() {
        return this.alertsEnabled;
    }

    public void setAlertsEnabled(boolean alertsEnabled) {
        this.alertsEnabled = alertsEnabled;
    }
}

