/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.api;

import dev.brighten.antivpn.AntiVPN;
import dev.brighten.antivpn.api.APIPlayer;
import dev.brighten.antivpn.api.CheckResult;
import dev.brighten.antivpn.utils.StringUtil;
import dev.brighten.antivpn.utils.Tuple;
import dev.brighten.antivpn.utils.json.JSONException;
import dev.brighten.antivpn.web.FunkemunkyAPI;
import dev.brighten.antivpn.web.objects.VPNResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public abstract class VPNExecutor {
    public static ScheduledExecutorService threadExecutor = Executors.newScheduledThreadPool(2);
    private final Set<UUID> whitelisted = Collections.synchronizedSet(new HashSet());
    private final Set<String> whitelistedIps = Collections.synchronizedSet(new HashSet());
    private final List<Tuple<CheckResult, UUID>> toKick = Collections.synchronizedList(new LinkedList());

    public abstract void registerListeners();

    public abstract void log(Level var1, String var2, Object ... var3);

    public abstract void log(String var1, Object ... var2);

    public abstract void logException(String var1, Throwable var2);

    public abstract void runCommand(String var1);

    public void logException(Throwable ex) {
        this.logException("An exception occurred: " + ex.getMessage(), ex);
    }

    public void startKickChecks() {
        threadExecutor.scheduleAtFixedRate(() -> {
            List<Tuple<CheckResult, UUID>> list = this.toKick;
            synchronized (list) {
                if (this.toKick.isEmpty()) {
                    return;
                }
                Iterator<Tuple<CheckResult, UUID>> i = this.toKick.iterator();
                while (i.hasNext()) {
                    Tuple<CheckResult, UUID> toCheck = i.next();
                    Optional<APIPlayer> player = AntiVPN.getInstance().getPlayerExecutor().getPlayer(toCheck.second());
                    if (player.isEmpty()) continue;
                    this.handleKickingOfPlayer(toCheck.first(), player.get());
                    i.remove();
                }
            }
        }, 8L, 2L, TimeUnit.SECONDS);
    }

    public void handleKickingOfPlayer(CheckResult result, APIPlayer player) {
        if (AntiVPN.getInstance().getVpnConfig().alertToStaff()) {
            AntiVPN.getInstance().getPlayerExecutor().getOnlinePlayers().stream().filter(APIPlayer::isAlertsEnabled).forEach(pl -> pl.sendMessage(StringUtil.translateAlternateColorCodes('&', StringUtil.varReplace(AntiVPN.getInstance().getVpnConfig().alertMessage(), player, result.response()))));
        }
        if (AntiVPN.getInstance().getVpnConfig().kickPlayersOnDetect()) {
            switch (result.resultType()) {
                case DENIED_PROXY: {
                    player.kickPlayer(StringUtil.varReplace(AntiVPN.getInstance().getVpnConfig().getKickString(), player, result.response()));
                    break;
                }
                case DENIED_COUNTRY: {
                    player.kickPlayer(StringUtil.varReplace(AntiVPN.getInstance().getVpnConfig().countryVanillaKickReason(), player, result.response()));
                }
            }
        }
        if (!AntiVPN.getInstance().getVpnConfig().runCommands()) {
            return;
        }
        switch (result.resultType()) {
            case DENIED_PROXY: {
                for (String command : AntiVPN.getInstance().getVpnConfig().commands()) {
                    this.runCommand(StringUtil.translateAlternateColorCodes('&', StringUtil.varReplace(command, player, result.response())));
                }
                break;
            }
            case DENIED_COUNTRY: {
                for (String command : AntiVPN.getInstance().getVpnConfig().countryKickCommands()) {
                    this.runCommand(StringUtil.translateAlternateColorCodes('&', StringUtil.varReplace(command, player, result.response())));
                }
                break;
            }
        }
    }

    public boolean isWhitelisted(UUID uuid) {
        if (AntiVPN.getInstance().getVpnConfig().isDatabaseEnabled()) {
            return AntiVPN.getInstance().getDatabase().isWhitelisted(uuid);
        }
        return this.whitelisted.contains(uuid);
    }

    public boolean isWhitelisted(String ip) {
        if (AntiVPN.getInstance().getVpnConfig().isDatabaseEnabled()) {
            return AntiVPN.getInstance().getDatabase().isWhitelisted(ip);
        }
        return this.whitelistedIps.contains(ip);
    }

    public CompletableFuture<VPNResponse> checkIp(String ip) {
        return CompletableFuture.supplyAsync(() -> {
            Optional<VPNResponse> cachedRes = AntiVPN.getInstance().getDatabase().getStoredResponse(ip);
            if (cachedRes.isPresent()) {
                return cachedRes.get();
            }
            try {
                VPNResponse response = FunkemunkyAPI.getVPNResponse(ip, AntiVPN.getInstance().getVpnConfig().getLicense(), true);
                if (response.isSuccess()) {
                    AntiVPN.getInstance().getDatabase().cacheResponse(response);
                } else {
                    this.log("Query to VPN API failed! Reason: " + response.getFailureReason(), new Object[0]);
                }
                return response;
            }
            catch (JSONException | IOException e) {
                this.log("Query to VPN API failed! Reason: " + e.getMessage(), new Object[0]);
                return VPNResponse.FAILED_RESPONSE;
            }
        }, threadExecutor);
    }

    public abstract void disablePlugin();

    public Set<UUID> getWhitelisted() {
        return this.whitelisted;
    }

    public Set<String> getWhitelistedIps() {
        return this.whitelistedIps;
    }

    public List<Tuple<CheckResult, UUID>> getToKick() {
        return this.toKick;
    }
}

