/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.depends;

import dev.brighten.antivpn.AntiVPN;
import dev.brighten.antivpn.depends.MavenLibrary;
import dev.brighten.antivpn.depends.Relocate;
import dev.brighten.antivpn.depends.URLClassLoaderAccess;
import dev.brighten.antivpn.utils.NonnullByDefault;
import dev.brighten.antivpn.utils.Supplier;
import dev.brighten.antivpn.utils.Suppliers;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;

@NonnullByDefault
public final class LibraryLoader {
    private static final Supplier<URLClassLoaderAccess> URL_INJECTOR = AntiVPN.getInstance().getClass().getClassLoader() instanceof URLClassLoader ? Suppliers.memoize(() -> URLClassLoaderAccess.create((URLClassLoader)AntiVPN.getInstance().getClass().getClassLoader())) : null;

    public static void loadAll(Object object) {
        if (URL_INJECTOR == null) {
            return;
        }
        LibraryLoader.loadAll(object.getClass());
    }

    public static void loadAll(Class<?> clazz) {
        MavenLibrary[] libs;
        if (URL_INJECTOR == null) {
            return;
        }
        for (MavenLibrary lib : libs = (MavenLibrary[])clazz.getDeclaredAnnotationsByType(MavenLibrary.class)) {
            HashMap<String, String> relocations = new HashMap<String, String>();
            for (Relocate relocate : lib.relocations()) {
                relocations.put(relocate.from().replace("\\", ""), relocate.to());
            }
            LibraryLoader.load(lib.groupId().replace("\\", ""), lib.artifactId(), lib.version(), lib.repo().url(), relocations);
        }
    }

    public static void load(String groupId, String artifactId, String version, String repoUrl, Map<String, String> relocations) {
        LibraryLoader.load(new Dependency(groupId, artifactId, version, repoUrl), relocations);
    }

    public static void load(Dependency d, Map<String, String> relocations) {
        File jarToLoad;
        System.out.printf("Loading dependency %s:%s:%s from %s%n", d.getGroupId(), d.getArtifactId(), d.getVersion(), d.getRepoUrl());
        String name = d.getArtifactId() + "-" + d.getVersion();
        String fileName = name + ".jar";
        if (!relocations.isEmpty()) {
            fileName = name + "-relocated.jar";
        }
        File saveLocation = new File(LibraryLoader.getLibFolder(), fileName);
        File originalJar = new File(LibraryLoader.getLibFolder(), name + ".jar");
        if (!originalJar.exists()) {
            try {
                System.out.println("Dependency '" + name + "' is not already in the libraries folder. Attempting to download...");
                URL url = d.getUrl();
                try (InputStream is = url.openStream();){
                    Files.copy(is, originalJar.toPath(), new CopyOption[0]);
                }
                System.out.println("Dependency '" + name + "' successfully downloaded.");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Unable to download dependency: " + String.valueOf(d), e);
            }
        }
        if (!relocations.isEmpty() && !saveLocation.exists()) {
            try {
                System.out.println("Relocating packages for " + name + "...");
                LibraryLoader.relocateJar(originalJar, saveLocation, relocations);
                System.out.println("Successfully relocated packages for " + name);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Failed to relocate packages for dependency: " + String.valueOf(d), e);
            }
        }
        File file = jarToLoad = relocations.isEmpty() ? originalJar : saveLocation;
        if (!jarToLoad.exists()) {
            throw new RuntimeException("Unable to find dependency jar: " + jarToLoad.getAbsolutePath());
        }
        try {
            URL_INJECTOR.get().addURL(jarToLoad.toURI().toURL());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load dependency: " + String.valueOf(jarToLoad), e);
        }
        System.out.println("Loaded dependency '" + name + "' successfully.");
    }

    private static void relocateJar(File sourceJar, File targetJar, Map<String, String> relocations) throws IOException {
        HashMap<String, StringBuilder> serviceFiles = new HashMap<String, StringBuilder>();
        try (JarFile jar = new JarFile(sourceJar);
             JarOutputStream jos = new JarOutputStream(Files.newOutputStream(targetJar.toPath(), new OpenOption[0]));){
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (entry.isDirectory()) continue;
                InputStream is = jar.getInputStream(entry);
                try {
                    if (name.startsWith("META-INF/services/")) {
                        LibraryLoader.processServiceFile(name, is, serviceFiles, relocations);
                        continue;
                    }
                    if (name.endsWith(".class")) {
                        String relocatedPath = LibraryLoader.relocateClassPath(name, relocations);
                        JarEntry newEntry = new JarEntry(relocatedPath);
                        jos.putNextEntry(newEntry);
                        byte[] classBytes = LibraryLoader.readAllBytes(is);
                        byte[] relocatedBytes = LibraryLoader.relocateClass(classBytes, relocations);
                        jos.write(relocatedBytes);
                        jos.closeEntry();
                        continue;
                    }
                    JarEntry newEntry = new JarEntry(name);
                    jos.putNextEntry(newEntry);
                    LibraryLoader.copyStream(is, jos);
                    jos.closeEntry();
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            for (Map.Entry entry : serviceFiles.entrySet()) {
                try {
                    JarEntry serviceEntry = new JarEntry((String)entry.getKey());
                    jos.putNextEntry(serviceEntry);
                    jos.write(((StringBuilder)entry.getValue()).toString().getBytes());
                    jos.closeEntry();
                }
                catch (Exception e) {
                    System.out.println("Warning: Could not write service file " + (String)entry.getKey() + ": " + e.getMessage());
                }
            }
        }
    }

    private static void processServiceFile(String name, InputStream is, Map<String, StringBuilder> serviceFiles, Map<String, String> relocations) throws IOException {
        String content = new String(LibraryLoader.readAllBytes(is));
        StringBuilder contentBuilder = serviceFiles.computeIfAbsent(name, k -> new StringBuilder());
        for (String line : content.split("\n")) {
            Object trimmed = line.trim();
            if (!((String)trimmed).isEmpty() && !((String)trimmed).startsWith("#")) {
                for (Map.Entry<String, String> relocation : relocations.entrySet()) {
                    if (!((String)trimmed).startsWith(relocation.getKey())) continue;
                    trimmed = relocation.getValue() + ((String)trimmed).substring(relocation.getKey().length());
                    break;
                }
            }
            contentBuilder.append((String)trimmed).append("\n");
        }
    }

    private static byte[] relocateClass(byte[] classBytes, Map<String, String> relocations) {
        try {
            Remapper prefixRemapper = LibraryLoader.getPrefixRemapper(relocations);
            ClassReader reader = new ClassReader(classBytes);
            ClassWriter writer = new ClassWriter(1){

                protected String getCommonSuperClass(String type1, String type2) {
                    try {
                        return super.getCommonSuperClass(type1, type2);
                    }
                    catch (RuntimeException e) {
                        return "java/lang/Object";
                    }
                }
            };
            ClassRemapper visitor = new ClassRemapper((ClassVisitor)writer, prefixRemapper);
            reader.accept((ClassVisitor)visitor, 8);
            return writer.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return classBytes;
        }
    }

    private static Remapper getPrefixRemapper(Map<String, String> relocations) {
        final HashMap<String, String> slashMappings = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : relocations.entrySet()) {
            String fromSlash = entry.getKey().replace('.', '/');
            String toSlash = entry.getValue().replace('.', '/');
            slashMappings.put(fromSlash, toSlash);
        }
        return new Remapper(){

            public String map(String typeName) {
                if (typeName == null) {
                    return null;
                }
                for (Map.Entry entry : slashMappings.entrySet()) {
                    String from = (String)entry.getKey();
                    String to = (String)entry.getValue();
                    if (!typeName.startsWith(from)) continue;
                    return to + typeName.substring(from.length());
                }
                return typeName;
            }
        };
    }

    private static String relocateClassPath(String path, Map<String, String> relocations) {
        Object packagePath = path.substring(0, path.length() - 6).replace('/', '.');
        for (Map.Entry<String, String> relocation : relocations.entrySet()) {
            if (!((String)packagePath).startsWith(relocation.getKey())) continue;
            packagePath = relocation.getValue() + ((String)packagePath).substring(relocation.getKey().length());
            break;
        }
        return ((String)packagePath).replace('.', '/') + ".class";
    }

    private static byte[] readAllBytes(InputStream is) throws IOException {
        int bytesRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        while ((bytesRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, bytesRead);
        }
        return buffer.toByteArray();
    }

    private static void copyStream(InputStream is, OutputStream os) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[1024];
        while ((bytesRead = is.read(buffer)) != -1) {
            os.write(buffer, 0, bytesRead);
        }
    }

    private static File getLibFolder() {
        File pluginDataFolder = AntiVPN.getInstance().getPluginFolder();
        File libs = new File(pluginDataFolder, "libraries");
        if (libs.mkdirs()) {
            System.out.println("Created libraries folder!");
        }
        return libs;
    }

    @NonnullByDefault
    public static final class Dependency {
        private final String groupId;
        private final String artifactId;
        private final String version;
        private final String repoUrl;
        private final String originalGroupId;
        private final String originalArtifactId;

        public Dependency(String groupId, String artifactId, String version, String repoUrl) {
            this.originalGroupId = Objects.requireNonNull(groupId, "groupId");
            this.originalArtifactId = Objects.requireNonNull(artifactId, "artifactId");
            this.groupId = this.originalGroupId;
            this.artifactId = this.originalArtifactId;
            this.version = Objects.requireNonNull(version, "version");
            this.repoUrl = Objects.requireNonNull(repoUrl, "repoUrl");
        }

        public URL getUrl() throws MalformedURLException {
            Object repo = this.repoUrl;
            if (!((String)repo).endsWith("/")) {
                repo = (String)repo + "/";
            }
            repo = (String)repo + "%s/%s/%s/%s-%s.jar";
            String url = String.format((String)repo, this.originalGroupId.replace(".", "/"), this.originalArtifactId, this.version, this.originalArtifactId, this.version);
            return new URL(url);
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public String getRepoUrl() {
            return this.repoUrl;
        }

        public String getOriginalGroupId() {
            return this.originalGroupId;
        }

        public String getOriginalArtifactId() {
            return this.originalArtifactId;
        }
    }
}

