/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.message;

import dev.brighten.antivpn.AntiVPN;
import dev.brighten.antivpn.message.VpnString;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class MessageHandler {
    private final Map<String, VpnString> messages = new HashMap<String, VpnString>();

    public VpnString getString(String key) {
        if (!this.messages.containsKey(key)) {
            throw new NullPointerException("There is no VpnString with the key \"" + key + "\"");
        }
        return this.messages.get(key);
    }

    public void reloadStrings() {
        for (VpnString value : this.messages.values()) {
            value.updateString();
        }
    }

    public void clearStrings() {
        this.messages.clear();
    }

    public void addString(VpnString string, Function<VpnString, String> getter) {
        string.setConfigStringGetter(getter);
        getter.apply(string);
        AntiVPN.getInstance().getExecutor().log("Added string " + string.getKey(), new Object[0]);
        this.messages.put(string.getKey(), string);
    }

    public void initStrings(Function<VpnString, String> getter) {
        this.addString(new VpnString("command-misc-playerRequired", "&cYou must be a player to execute this command!"), getter);
        this.addString(new VpnString("command-alerts-toggled", "&7Your player proxy notifications have been set to: &e%state%"), getter);
        this.addString(new VpnString("command-reload-complete", "&aSuccessfully reloaded KauriVPN plugin!"), getter);
        this.addString(new VpnString("no-permission", "&cNo permission."), getter);
    }
}

