/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.shaded.com.mongodb;

import dev.brighten.antivpn.shaded.com.mongodb.AcknowledgedBulkWriteResult;
import dev.brighten.antivpn.shaded.com.mongodb.BulkWriteError;
import dev.brighten.antivpn.shaded.com.mongodb.BulkWriteException;
import dev.brighten.antivpn.shaded.com.mongodb.BulkWriteResult;
import dev.brighten.antivpn.shaded.com.mongodb.DBObject;
import dev.brighten.antivpn.shaded.com.mongodb.DBObjects;
import dev.brighten.antivpn.shaded.com.mongodb.MongoBulkWriteException;
import dev.brighten.antivpn.shaded.com.mongodb.UnacknowledgedBulkWriteResult;
import dev.brighten.antivpn.shaded.com.mongodb.bulk.BulkWriteUpsert;
import dev.brighten.antivpn.shaded.com.mongodb.bulk.WriteConcernError;
import dev.brighten.antivpn.shaded.org.bson.BsonDocument;
import dev.brighten.antivpn.shaded.org.bson.BsonDocumentReader;
import dev.brighten.antivpn.shaded.org.bson.codecs.Decoder;
import dev.brighten.antivpn.shaded.org.bson.codecs.DecoderContext;
import java.util.ArrayList;
import java.util.List;

final class BulkWriteHelper {
    static BulkWriteResult translateBulkWriteResult(dev.brighten.antivpn.shaded.com.mongodb.bulk.BulkWriteResult bulkWriteResult, Decoder<DBObject> decoder) {
        if (bulkWriteResult.wasAcknowledged()) {
            return new AcknowledgedBulkWriteResult(bulkWriteResult.getInsertedCount(), bulkWriteResult.getMatchedCount(), bulkWriteResult.getDeletedCount(), bulkWriteResult.getModifiedCount(), BulkWriteHelper.translateBulkWriteUpserts(bulkWriteResult.getUpserts(), decoder));
        }
        return new UnacknowledgedBulkWriteResult();
    }

    static List<dev.brighten.antivpn.shaded.com.mongodb.BulkWriteUpsert> translateBulkWriteUpserts(List<BulkWriteUpsert> upserts, Decoder<DBObject> decoder) {
        ArrayList<dev.brighten.antivpn.shaded.com.mongodb.BulkWriteUpsert> retVal = new ArrayList<dev.brighten.antivpn.shaded.com.mongodb.BulkWriteUpsert>(upserts.size());
        for (BulkWriteUpsert cur : upserts) {
            retVal.add(new dev.brighten.antivpn.shaded.com.mongodb.BulkWriteUpsert(cur.getIndex(), BulkWriteHelper.getUpsertedId(cur, decoder)));
        }
        return retVal;
    }

    private static Object getUpsertedId(BulkWriteUpsert cur, Decoder<DBObject> decoder) {
        return decoder.decode(new BsonDocumentReader(new BsonDocument("_id", cur.getId())), DecoderContext.builder().build()).get("_id");
    }

    static BulkWriteException translateBulkWriteException(MongoBulkWriteException e, Decoder<DBObject> decoder) {
        return new BulkWriteException(BulkWriteHelper.translateBulkWriteResult(e.getWriteResult(), decoder), BulkWriteHelper.translateWriteErrors(e.getWriteErrors()), BulkWriteHelper.translateWriteConcernError(e.getWriteConcernError()), e.getServerAddress());
    }

    static dev.brighten.antivpn.shaded.com.mongodb.WriteConcernError translateWriteConcernError(WriteConcernError writeConcernError) {
        return writeConcernError == null ? null : new dev.brighten.antivpn.shaded.com.mongodb.WriteConcernError(writeConcernError.getCode(), writeConcernError.getMessage(), DBObjects.toDBObject(writeConcernError.getDetails()));
    }

    static List<BulkWriteError> translateWriteErrors(List<dev.brighten.antivpn.shaded.com.mongodb.bulk.BulkWriteError> errors) {
        ArrayList<BulkWriteError> retVal = new ArrayList<BulkWriteError>(errors.size());
        for (dev.brighten.antivpn.shaded.com.mongodb.bulk.BulkWriteError cur : errors) {
            retVal.add(new BulkWriteError(cur.getCode(), cur.getMessage(), DBObjects.toDBObject(cur.getDetails()), cur.getIndex()));
        }
        return retVal;
    }

    private BulkWriteHelper() {
    }
}

